/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.function.parser.common;

import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;

public class FunctionParserUtils {
    public static final Pattern U16_CHAR_PATTERN = Pattern.compile("\\\\u([a-fA-F0-9]{4})(?s).*");
    public static final Pattern U32_CHAR_PATTERN = Pattern.compile("\\\\U([a-fA-F0-9]{8})(?s).*");
    public static final Pattern OCTAL_CHAR_PATTERN = Pattern.compile("\\\\([01][0-7]{2})(?s).*");
    public static final Pattern ESCAPED_CHAR_PATTERN = Pattern.compile("\\\\((?s).)(?s).*");

    private static String unescapeSQLString(String b) {
        StringBuilder sb = new StringBuilder(b.length());
        if (b.startsWith("r") || b.startsWith("R")) {
            return b.substring(2, b.length() - 1);
        }
        CharBuffer charBuffer = CharBuffer.wrap(b, 1, b.length() - 1);
        while (charBuffer.hasRemaining()) {
            int cp;
            String charString = charBuffer.subSequence(0, charBuffer.remaining()).toString();
            Matcher u16Matcher = U16_CHAR_PATTERN.matcher(charString);
            Matcher u32Matcher = U32_CHAR_PATTERN.matcher(charString);
            Matcher octalMatcher = OCTAL_CHAR_PATTERN.matcher(charString);
            Matcher escapedMatcher = ESCAPED_CHAR_PATTERN.matcher(charString);
            if (u16Matcher.matches()) {
                cp = Integer.parseInt(u16Matcher.group(1), 16);
                sb.append((char)cp);
                charBuffer.position(charBuffer.position() + 6);
                continue;
            }
            if (u32Matcher.matches()) {
                long codePoint = Long.parseLong(u32Matcher.group(1), 16);
                if (codePoint < 65536L) {
                    sb.append((char)(codePoint & 0xFFFFL));
                } else {
                    int highSurrogate = (int)((codePoint - 65536L) / 1024L + 55296L);
                    int lowSurrogate = (int)((codePoint - 65536L) % 1024L + 56320L);
                    sb.append((char)highSurrogate);
                    sb.append((char)lowSurrogate);
                }
                charBuffer.position(charBuffer.position() + 10);
                continue;
            }
            if (octalMatcher.matches()) {
                cp = Integer.parseInt(octalMatcher.group(1), 8);
                sb.append((char)cp);
                charBuffer.position(charBuffer.position() + 4);
                continue;
            }
            if (escapedMatcher.matches()) {
                FunctionParserUtils.appendEscapedChar(sb, escapedMatcher.group(1).charAt(0));
                charBuffer.position(charBuffer.position() + 2);
                continue;
            }
            sb.append(charBuffer.get());
        }
        return sb.toString();
    }

    private static void appendEscapedChar(StringBuilder sb, char n) {
        switch (n) {
            case '0': {
                sb.append('\u0000');
                break;
            }
            case '\'': {
                sb.append('\'');
                break;
            }
            case '\"': {
                sb.append('\"');
                break;
            }
            case 'b': {
                sb.append('\b');
                break;
            }
            case 'n': {
                sb.append('\n');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'Z': {
                sb.append('\u001a');
                break;
            }
            case '\\': {
                sb.append('\\');
                break;
            }
            case '%': {
                sb.append("\\%");
                break;
            }
            case '_': {
                sb.append("\\_");
                break;
            }
            default: {
                sb.append(n);
            }
        }
    }

    public static String string(Token token) {
        return FunctionParserUtils.unescapeSQLString(token.getText());
    }

    public static double getDouble(Object val, String errMsg) {
        double resultValue;
        if (val instanceof Double) {
            resultValue = (Double)val;
        } else if (val instanceof Float) {
            resultValue = ((Float)val).floatValue();
        } else if (val instanceof Integer) {
            resultValue = ((Integer)val).intValue();
        } else if (val instanceof Long) {
            resultValue = ((Long)val).longValue();
        } else if (val instanceof BigDecimal) {
            resultValue = ((BigDecimal)val).doubleValue();
        } else {
            String msg = "\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\uff0c\u4ec5\u652f\u6301\u6570\u503c\u7c7b\u578b\uff01";
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                msg = errMsg;
            }
            throw new RuntimeException(msg);
        }
        return resultValue;
    }

    public static String getStrExprWithNull(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return "'" + obj + "'";
        }
        return obj.toString();
    }
}

