/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.license.authorize;

import com.geoway.atlas.hasp.AtlasHaspJNI;
import com.geoway.atlas.web.api.v2.license.authorize.CHECK_MODULE;
import com.geoway.atlas.web.api.v2.license.authorize.LicenseCheckException;
import com.geoway.atlas.web.api.v2.license.jna.JnaInvoke;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LicenseCheck {
    private static ConcurrentMap<String, Boolean> licenses = new ConcurrentHashMap<String, Boolean>();

    public static boolean isValid() {
        byte[] messageBytes = new byte[100];
        boolean login = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.MAIN, CHECK_MODULE.MAIN, messageBytes);
        if (login) {
            messageBytes = new byte[100];
            boolean algorithmCheck = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.ALGORITHM, CHECK_MODULE.ALGORITHM, messageBytes);
            if (algorithmCheck) {
                return true;
            }
            throw new LicenseCheckException(new String(messageBytes, StandardCharsets.UTF_8));
        }
        String error = new String(messageBytes, StandardCharsets.UTF_8);
        messageBytes = new byte[100];
        boolean IMELogin = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.IME_MAIN, CHECK_MODULE.IME_MAIN, messageBytes);
        if (IMELogin) {
            return true;
        }
        throw new LicenseCheckException(error);
    }

    public static boolean checkModule(int module) {
        String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return (Boolean)licenses.get(moduleName);
        }
        LicenseCheck.isValid();
        boolean login = JnaInvoke.DaemonFuncs_CheckModule(module);
        if (!login) {
            String error = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            throw new LicenseCheckException(error);
        }
        boolean check = JnaInvoke.DaemonFuncs_Check();
        if (!check) {
            String error2 = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            throw new LicenseCheckException(error2);
        }
        licenses.put(moduleName, check);
        return check;
    }

    public static boolean checkModuleNoException(int module) {
        String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return (Boolean)licenses.get(moduleName);
        }
        LicenseCheck.isValid();
        boolean login = JnaInvoke.DaemonFuncs_CheckModule(module);
        if (!login) {
            String error = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            return false;
        }
        boolean check = JnaInvoke.DaemonFuncs_Check();
        if (!check) {
            String error2 = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            return false;
        }
        licenses.put(moduleName, check);
        return check;
    }

    public static void main(String[] args) {
        boolean valid = LicenseCheck.isValid();
        System.out.println("main module:" + valid);
    }
}

