/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AccessLogBuilder {
    public static String getLog(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String remoteAddr = request.getRemoteAddr();
        String remoteIp = request.getRemoteHost();
        int remotePort = request.getRemotePort();
        String remoteUser = request.getRemoteUser();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)remoteUser)) {
            sb.append(remoteUser).append("@");
        }
        sb.append(remoteAddr).append("(").append(remoteIp).append("):").append(remotePort).append(" ").append(method.toUpperCase()).append(" ").append(uri);
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) {
            sb.append("?");
            Map parameterMap = request.getParameterMap();
            for (String key : parameterMap.keySet()) {
                sb.append(key).append("=");
                String value = request.getParameter(key);
                if (value != null) {
                    sb.append(value);
                }
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

