package com.geoway.atlas.web.api.v2.component.bean;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @author zhaotong 2023/1/8 23:30
 */
@Component
public class AtlasGisToolkitBeanFactory implements ApplicationContextAware {

    private static ApplicationContext applicationContext = null;

    public AtlasGisToolkitBeanFactory() {
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (AtlasGisToolkitBeanFactory.applicationContext == null) {
            AtlasGisToolkitBeanFactory.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    /**
     * 拿到ApplicationContext对象实例后就可以手动获取Bean的注入实例对象
     */
    public static <T> T getBean(Class<T> clazz) {
        return getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return getApplicationContext().getBean(name, clazz);
    }

    public static ObjectMapper getObjectMapper() {
        return getBean(ObjectMapper.class);
    }
}
