package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.common.error.GSparkException;
import com.geoway.atlas.common.utils.InheritableThreadLocalUtils;
import com.geoway.atlas.data.vector.spark.common.rpc.common.AtlasRpcServerException;
import com.geoway.atlas.data.vector.spark.common.rpc.common.GrpcExceptionUtil;
import com.geoway.atlas.web.api.v2.utils.AccessLogBuilder;
import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.utils.RequestUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import io.grpc.StatusRuntimeException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * 主要用于异步方法调用
 *
 * @author zhaotong
 * @version 1.0
 * @description
 * @date 2021/5/12 10:16
 */
@Aspect
@Component
@Slf4j
public class AsyncAop {

    @Autowired
    private Constants constants;

    @Autowired
    private JobManager jobManager;

    @Autowired
    @Qualifier(value = "asyncJobPool")
    private ExecutorService asyncJobPool;

    @Around("@annotation(asdel)")
    public Map<String, Object> asyncMethod(ProceedingJoinPoint point, AsyncDeal asdel) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) Objects.requireNonNull(
                RequestContextHolder.getRequestAttributes());
        RequestContextHolder.setRequestAttributes(requestAttributes, true);
        HttpServletRequest request = requestAttributes.getRequest();
        // 获取所有的输入参数
        Map<String, String> fieldJoinParams =
                RequestUtils.getParams(request,
                        Arrays.asList("taskid", "jobid"));

        Object[] objs = point.getArgs();
        objs[objs.length - 1] = fieldJoinParams;
        /** 添加埋点日志 */
        log.info(AccessLogBuilder.getLog(request));
        /** 获取任务的id */
        String jobId = jobManager.getJobId(request);
        /** 获取任务的id */
        String rawTaskId = jobManager.getTaskId(request);

        Map<String, Object> response = ResponseBuilder.buildAsyncResponse(jobId);
        String jobStatus = jobManager.startJob(rawTaskId, jobId, ResponseBuilder.buildRunning(jobId));

        if (constants.jobManagerYes().equalsIgnoreCase(jobStatus)) {

            Future<?> future = asyncJobPool.submit(() -> {
                try {
                    // 添加线程变量方便记录不同task的日志, taskid为了统一都删除了'-'符号
                    InheritableThreadLocalUtils.setLocalProperty(InheritableThreadLocalUtils.ATLAS_TASK_ID(),
                            StringUtils.replace(rawTaskId, "-", ""));
                    // 执行任务
                    Map<String, Object> objectMap = (Map<String, Object>) point.proceed(objs);
                    jobManager.finishJob(rawTaskId, jobId, objectMap);
                    log.info("任务" + jobId + "成功!");
                } catch (Throwable throwable) {
                    Throwable nThrowable;
                    if (throwable instanceof GSparkException) {
                        nThrowable = (RuntimeException) throwable;
                    } else if (throwable instanceof StatusRuntimeException) {
                        Throwable nt = GrpcExceptionUtil.unwrapException((StatusRuntimeException) throwable);
                        if (nt instanceof RuntimeException) {
                            nThrowable = (RuntimeException) nt;
                        } else {
                            nThrowable = new AtlasRpcServerException(nt.getMessage(),
                                    nt.getStackTrace());
                        }
                    } else {
                        if (throwable instanceof RuntimeException) {
                            nThrowable = (RuntimeException) throwable;
                        } else {
                            nThrowable = new AtlasRpcServerException(throwable.getMessage(),
                                    throwable.getStackTrace());
                        }
                    }
                    jobManager.finishJob(rawTaskId, jobId, ResponseBuilder.buildFailed(nThrowable));
                    log.error("任务" + jobId + "失败!", nThrowable);
                }
            });
            jobManager.putFuture(rawTaskId, jobId, future);
//            CompletableFuture.supplyAsync(() -> {
//                try {
//                    return (Map<String, Object>) point.proceed(objs);
//                } catch (Throwable throwable) {
//                    if (throwable instanceof GSparkException) {
//                        throw (RuntimeException) throwable;
//                    } else if (throwable instanceof StatusRuntimeException) {
//                        Throwable nt = GrpcExceptionUtil.unwrapException((StatusRuntimeException) throwable);
//                        if (nt instanceof RuntimeException) {
//                            throw (RuntimeException) nt;
//                        } else {
//                            throw new AtlasRpcServerException(nt.getMessage(),
//                                    nt.getStackTrace());
//                        }
//                    } else {
//                        if (throwable instanceof RuntimeException) {
//                            throw (RuntimeException) throwable;
//                        } else {
//                            throw new AtlasRpcServerException(throwable.getMessage(),
//                                    throwable.getStackTrace());
//                        }
//                    }
//                }
//            }, asyncJobPool).whenComplete((objectMap, throwable) -> {
//                if (throwable == null) {
//                    jobManager.finishJob(taskId, jobId, objectMap);
//                    log.info("任务" + jobId + "成功!");
//                } else {
//                    jobManager.finishJob(taskId, jobId, ResponseBuilder.buildFailed(throwable));
//                    log.error("任务" + jobId + "失败!", throwable);
//                }
//            });
        } else {
            log.warn("任务:" + rawTaskId + ",工作项:" + jobId + ",已经执行，请勿重复提交!");
        }

        return response;
    }

}
