package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.web.api.v2.utils.ThreadFactoryBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author zhaotong 2022/9/6 18:08
 */

@Component
public class JobPool {

    @Value("${async.job.threads.num}")
    private Integer nThread;

    /**
     * 创建job异步线程池
     */
    @Bean(value = "asyncJobPool", destroyMethod = "shutdownNow")
    public ExecutorService getThreadPool() {
        return Executors.newFixedThreadPool(nThread, ThreadFactoryBuilder.getNamedThreadFactory("asyncJobPool"));
    }

    /**
     * 创建job异步线程池
     */
    @Bean(value = "rpcClientPool", destroyMethod = "shutdownNow")
    public ExecutorService getRpcClientPool() {
        return Executors.newFixedThreadPool(nThread, ThreadFactoryBuilder.getNamedThreadFactory("rpcClientPool"));
    }

    /**
     * 创建job异步线程池
     */
    @Bean(value = "rpcServerPool", destroyMethod = "shutdownNow")
    public ExecutorService getRpcServerPool() {
        return Executors.newFixedThreadPool(nThread, ThreadFactoryBuilder.getNamedThreadFactory("rpcServerPool"));
    }

}
