package com.geoway.atlas.web.api.v2.service;

import java.util.Map;

/**
 * 数据相关接口
 *
 * @author zhaotong 2022/9/9 16:13
 */
public interface DataServer {

    /**
     * 载入矢量数据
     *
     * @param dataName        数据名称
     * @param dataStoreFormat 数据源格式
     * @param params          载入数据参数
     * @param taskId          taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> loadVector(
            String dataName,
            String dataStoreFormat,
            Map<String, String> params,
            String taskId,
            String jobId);


    /**
     * 输出矢量数据
     *
     * @param dataName        数据名称
     * @param dataStoreFormat 数据源格式
     * @param params          输出数据参数
     * @param taskId          taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> saveVector(
            String dataName,
            String dataStoreFormat,
            Map<String, String> params,
            String taskId,
            String jobId);

    /**
     * 展示矢量数据
     *
     * @return 矢量数据信息
     */
    Map<String, Object> showVector();

    /**
     * 展示数据详情
     *
     * @param dataName 数据名称
     * @param taskId   工作流id
     * @param jobId    任务id
     * @return 矢量数据信息
     */
    Map<String, Object> descVector(String dataName,
                                   String taskId,
                                   String jobId);

    /**
     * 展示数据详情
     *
     * @param dataName 数据名称
     * @param taskId   工作流id
     * @param jobId    任务id
     * @return 矢量数据信息
     */
    Map<String, Object> existVector(String dataName,
                                    String taskId,
                                    String jobId);

    /**
     * 数据重命名
     *
     * @param rawDataName 原始数据名称
     * @param newDataName 新数据名称
     * @param taskId      任务Id
     * @param jobId       jobId
     * @return 返回重命名信息
     */
    Map<String, Object> renameData(String rawDataName,
                                   String newDataName,
                                   String taskId,
                                   String jobId);

    /**
     * 获取载入后的图层名称
     *
     * @param identity 输入的图层标识
     * @param params   参数名称
     * @param taskId   工作流Id
     * @param jobId    任务Id
     * @return 返回图层标识名称
     */
    String loadVectorLayer(String identity,
                           Map<String, String> params,
                           String taskId,
                           String jobId);

    /**
     * 获取载入后的图层名称
     *
     * @param identity 输入的图层标识
     * @param params   参数名称
     * @param taskId   工作流Id
     * @param jobId    任务Id
     * @return 返回图层标识名称
     */
    String loadGraphLayer(String identity,
                          Map<String, String> params,
                          String taskId,
                          String jobId);

    /**
     * 获取载入栅格后的图层
     *
     * @param identity 输入的图层标识
     * @param params   参数名称
     * @param taskId   工作流Id
     * @param jobId    任务Id
     * @return 返回图层标识名称
     */
    String loadRasterLayer(String identity,
                           Map<String, String> params,
                           String taskId,
                           String jobId);


    /**
     * 拓展保存图层接口
     *
     * @param identity   输入的图层标识
     * @param saveParams 保存数据参数
     * @param taskId     工作流Id
     * @param jobId      任务Id
     */
    void saveVectorLayer(String identity,
                         String persistUrl,
                         Map<String, String> extraSaveParams,
                         String taskId,
                         String jobId);

    /**
     * 拓展保存图数据接口
     *
     * @param identity   输入的图层标识
     * @param saveParams 保存数据参数
     * @param taskId     工作流Id
     * @param jobId      任务Id
     */
    void saveGraphLayer(String identity,
                        String persistUrl,
                        Map<String, String> extraSaveParams,
                        String taskId,
                        String jobId);

    /**
     * 拓展保存栅格数据接口
     *
     * @param identity   输入的图层标识
     * @param saveParams 保存数据参数
     * @param taskId     工作流Id
     * @param jobId      任务Id
     */
    void saveRasterLayer(String identity,
                         String persistUrl,
                         Map<String, String> extraSaveParams,
                         String taskId,
                         String jobId);

    /**
     * 保存图层
     *
     * @param identity   输入的图层标识
     * @param saveParams 保存数据参数
     * @param taskId     工作流Id
     * @param jobId      任务Id
     */
    void saveVectorLayer(String identity,
                         String persistUrl,
                         String taskId,
                         String jobId);

    /**
     * 生成图层名称
     *
     * @param layerUrl 图层url地址
     * @return 返回图层名称
     */
    String generalResultLayerName(String layerUrl);


    /**
     * 生成图层名称
     *
     * @param layerUrl 图层url地址
     * @return 返回图层名称
     * @deprecated 请使用 generalResultLayerName 方法
     */
    @Deprecated
    String generalMemoryLayerName(String layerUrl);
}
