package com.geoway.atlas.web.api.v2.service.pkg;

import java.util.Map;

/**
 * @author zhaotong 2022/11/7 10:30
 */
public interface SpatialStatisticServer {

    /**
     * 面积计算算子
     *
     * @param baseIdentity        基础图层标识
     * @param calculateAreaParams 面积计算参数
     * @param resultIdentity      结果图层标识
     * @param persistDisk         是否持久化到磁盘
     * @param taskId              任务Id
     * @param jobId               jobId
     * @return 返回面积计算的结果
     */
    Map<String, Object> calculateProcess(String baseIdentity,
                                         Map<String, String> calculateAreaParams,
                                         String resultIdentity,
                                         boolean persistDisk,
                                         String resultUrl,
                                         String taskId,
                                         String jobId);

    /**
     * 按字典统计
     *
     * @param baseIdentity   基础图层标识
     * @param filterSql      属性筛选语句
     * @param byColParams    统计参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化磁盘
     * @param resultUrl      结果数据路径
     * @param taskId         任务id
     * @param jobId          jobId
     * @return 返回响应信息
     */
    Map<String, Object> byDictProcess(String baseIdentity,
                                      String filterSql,
                                      Map<String, String> byColParams,
                                      String resultIdentity,
                                      boolean persistDisk,
                                      String resultUrl,
                                      String taskId,
                                      String jobId);

    /**
     * 图形统计
     *
     * @param baseIdentity   基础图层标识
     * @param filterSql      属性筛选语句
     * @param byColParams    统计参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化磁盘
     * @param resultUrl      结果数据路径
     * @param taskId         任务id
     * @param jobId          jobId
     * @return 返回响应信息
     */
    Map<String, Object> byShapeProcess(String baseIdentity,
                                       String filterSql,
                                       String staticIdentity,
                                       String rowPropertyField,
                                       String valueField,
                                       Map<String, String> byShapeParams,
                                       String resultIdentity,
                                       boolean persistDisk,
                                       String resultUrl,
                                       String taskId,
                                       String jobId);


    /**
     * geosot网格统计
     *
     * @param baseIdentity   基础图层
     * @param saveShape      是否保留图形
     * @param geosotParams   geosot网格参数
     * @param resultIdentity 结果图层
     * @param persistDisk    是否持久化
     * @param resultUrl      结果路径
     * @param taskId         任务Id
     * @param jobId          工作项Id
     * @return 返回响应信息
     */
    Map<String, Object> gridStatistic(String baseIdentity,
                                      boolean saveShape,
                                      Map<String, String> geosotParams,
                                      String resultIdentity,
                                      boolean persistDisk,
                                      String resultUrl,
                                      String taskId,
                                      String jobId);

    /**
     * 分组统计
     *
     * @param baseIdentity   基础图层标识
     * @param filterSql      筛选条件
     * @param groupByParams  分组参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化磁盘
     * @param resultUrl      结果数据路径
     * @param taskId         任务id
     * @param jobId          jobId
     * @return 返回响应信息
     */
    Map<String, Object> groupByProcess(String baseIdentity,
                                       String filterSql,
                                       Map<String, String> groupByParams,
                                       String resultIdentity,
                                       boolean persistDisk,
                                       String resultUrl,
                                       String taskId,
                                       String jobId);

    /**
     * 执行SQL查询
     *
     * @param baseIdentity   图层1名称
     * @param baseSuffix     图层1额外的后缀信息
     * @param otherIdentity  图层2名称
     * @param otherSuffix    图层2额外的后缀信息
     * @param paramMaps      参数
     * @param resultIdentity 结果名称
     * @param persistDisk    是否持久化内存
     * @param persistUrl     内存地址
     * @param nTaskId        作业id
     * @param jobId          任务id
     * @return 返回响应信息
     */
    Map<String, Object> sqlProcess(String baseIdentity,
                                   String baseSuffix,
                                   String otherIdentity,
                                   String otherSuffix,
                                   Map<String, String> paramMaps,
                                   String resultIdentity,
                                   boolean persistDisk,
                                   String persistUrl,
                                   String nTaskId,
                                   String jobId);

    /**
     * 执行平差算法
     *
     * @param baseIdentity   图层1名称
     * @param balanceDiffParams     平差参数
     * @param resultIdentity 结果名称
     * @param persistDisk    是否持久化内存
     * @param persistUrl     内存地址
     * @param nTaskId        作业id
     * @param jobId          任务id
     * @return 返回响应信息
     */
    Map<String, Object> balanceDiffProcess(
            String baseIdentity,
            Map<String, String> balanceDiffParams,
            String resultIdentity,
            boolean persistDisk,
            String resultUrl,
            String nTaskId,
            String jobId);
}
