package com.geoway.atlas.web.api.v2.service.pkg.impl;

import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.service.pkg.GraphAnalysisServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhaotong 2023/8/15 18:59
 */

@Slf4j
@Service
public class GraphAnalysisServerImpl implements GraphAnalysisServer {

    @Autowired
    private DataServer dataServer;

    @Autowired
    private RpcClientProxy client;

    @Override
    public Map<String, Object> commonProcess(String baseIdentity,
                                             String processName,
                                             Map<String, String> bfsParams,
                                             String resultIdentity,
                                             boolean persistDisk,
                                             String resultUrl,
                                             String taskId,
                                             String jobId,
                                             String response) {
        String baseLayerName =
                dataServer.loadGraphLayer(baseIdentity, new HashMap<>(), taskId, UUIDUtils.getUUID());

        String resultLayerName = dataServer.generalResultLayerName(resultIdentity);

        String message = client.getSparkRpcClientApi().unitaryProcess(
                AtlasTagUtils.getAtlasRpcDataTag(baseLayerName),
                processName,
                bfsParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultLayerName),
                taskId, UUIDUtils.getUUID());
        log.info(message);

        if (persistDisk) {
            dataServer.saveGraphLayer(resultLayerName, resultUrl, new HashMap<>(), taskId, jobId);
        }

        return ResponseBuilder.buildSuccess(response);
    }
}
