package com.geoway.atlas.web.api.v2.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 访问日志构造器
 *
 * @author zhaotong 2022/9/6 17:00
 */
public class AccessLogBuilder {

    /**
     * 获取日志信息
     *
     * @param request 请求信息
     * @return 返回日志信息
     */
    public static String getLog(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String remoteAddr = request.getRemoteAddr();
        String remoteIp = request.getRemoteHost();
        int remotePort = request.getRemotePort();
        String remoteUser = request.getRemoteUser();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(remoteUser)) {
            sb.append(remoteUser).append("@");
        }

        sb.append(remoteAddr)
                .append("(")
                .append(remoteIp)
                .append("):")
                .append(remotePort)
                .append(" ")
                .append(method.toUpperCase())
                .append(" ")
                .append(uri);

        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) {
            sb.append("?");
            Map<String, String[]> parameterMap = request.getParameterMap();
            for (String key : parameterMap.keySet()) {
                sb.append(key).append("=");
                String value = request.getParameter(key);
                if (value != null) {
                    sb.append(value);
                }
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }

        return sb.toString();
    }
}
