package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import com.geoway.atlas.data.vector.common.jts.JTSUtils$;
import com.geoway.atlas.data.vector.common.wkt.WktUtils$;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

/**
 * @author zhaotong 2023/11/14 11:29
 */
public class GeometryBoundaryUtils {

    public static Constants constants = AtlasGisToolkitBeanFactory.getBean(Constants.class);

    public static Map<Integer, String> getExtraFilter(RpcDescDataRespond baseData, RpcDescDataRespond otherData, double limitRate) {
        Map<String, String> baseDataDesc = baseData.getDataDescMap();
        Map<String, String> otherDataDesc = otherData.getDataDescMap();

        Geometry baseBoundary = null;
        Geometry otherBoundary = null;
        if (baseDataDesc.containsKey(constants.dataDescBoundary())) {
            baseBoundary = WktUtils$.MODULE$.read(baseDataDesc.get(constants.dataDescBoundary()));
            if (baseBoundary.isEmpty() || GeometryUtils.isEmptyEnvelope(baseBoundary)) {
                baseBoundary = null;
            }
        }

        if (otherDataDesc.containsKey(constants.dataDescBoundary())) {
            otherBoundary = WktUtils$.MODULE$.read(otherDataDesc.get(constants.dataDescBoundary()));
            if (otherBoundary.isEmpty() || GeometryUtils.isEmptyEnvelope(otherBoundary)) {
                otherBoundary = null;
            }
        }

        Map<Integer, String> result = new HashMap<>();

        if (baseBoundary != null && otherBoundary != null) {
            // 如果输入的两个图层坐标系相同
            String base_crs_info = baseDataDesc.get(constants.dataDescCrs());
            String other_crs_info = otherDataDesc.get(constants.dataDescCrs());
            boolean equalCRS = false;
            CoordinateReferenceSystem baseCRS = null;
            CoordinateReferenceSystem otherCRS = null;
            if (StringUtils.equals(base_crs_info, other_crs_info)) {
                equalCRS = true;
            } else {
                baseCRS = parseCRSString(base_crs_info);
                otherCRS = parseCRSString(other_crs_info);
                equalCRS = CrsUtils$.MODULE$.compareCrs(baseCRS, otherCRS);
            }

            // 在基础图层坐标系下相交的部分
            Geometry baseGeometry;
            // 在叠加图层坐标系下相交的部分
            Geometry otherGeometry;
            if (equalCRS) {
                Geometry geometry = AtlasOverlayOp.intersection(baseBoundary, otherBoundary);
                baseGeometry = geometry;
                otherGeometry = geometry;
            } else {
                // 求在叠加图层坐标系下相交的部分
                baseGeometry =
                        JTSUtils$.MODULE$.toGeometry(JTSUtils$.MODULE$.transform(otherBoundary.getEnvelopeInternal(), otherCRS, baseCRS));
                otherGeometry =
                        JTSUtils$.MODULE$.toGeometry(JTSUtils$.MODULE$.transform(baseBoundary.getEnvelopeInternal(), baseCRS, otherCRS));
            }

            BiFunction<String, Geometry, String> filterFunction =
                    (s, geometry) -> (geometry != null && !geometry.isEmpty()) ?
                            "st_intersects(" + s + ", st_geomfromtext('" + WktUtils$.MODULE$.write(geometry) + "', " +
                                    baseDataDesc.get(constants.dataDescCrs()) + "))"
                            : "1=0";
            if ((baseGeometry.getArea() / baseBoundary.getArea()) < limitRate) {
                result.put(0, filterFunction.apply(baseDataDesc.get(constants.dataDescDefaultGeometry()), baseGeometry));
            }

            if ((otherGeometry.getArea() / otherBoundary.getArea()) < limitRate) {
                result.put(1, filterFunction.apply(otherDataDesc.get(constants.dataDescDefaultGeometry()), otherGeometry));
            }
        }

        return result;
    }

    public static String addExtraFilter(String rawFilter, String extraFilter) {
        if (StringUtils.isBlank(rawFilter)) {
            return extraFilter;
        } else if (StringUtils.isBlank(extraFilter)) {
            return rawFilter;
        } else {
            return extraFilter + " AND (" + rawFilter + ")";
        }
    }

    public static CoordinateReferenceSystem parseCRSString(String CRSString) {
        if (StringUtils.isNumeric(CRSString)) {
            int epsgCode = Integer.parseInt(CRSString);
            return com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(epsgCode);
        }

        return com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_WKT(CRSString);
    }

}
