package com.geoway.atlas.web.api.v2.utils;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author zhaotong 2023/6/26 11:28
 */
public class UUIDUtils {

    /**
     * All possible chars for representing a number as a String
     */
    private static byte[] DIGITS = {
            '0', '1', '2', '3', '4', '5',
            '6', '7', '8', '9', 'a', 'b',
            'c', 'd', 'e', 'f', 'g', 'h',
            'i', 'j', 'k', 'l', 'm', 'n',
            'o', 'p', 'q', 'r', 's', 't',
            'u', 'v', 'w', 'x', 'y', 'z',
            'A', 'B', 'C', 'D', 'E', 'F',
            'G', 'H', 'I', 'J', 'K', 'L',
            'M', 'N', 'O', 'P', 'Q', 'R',
            'S', 'T', 'U', 'V', 'W', 'X',
            'Y', 'Z', '_', '-'};


    /**
     * 生成uuid，采用 jdk 9 的形式，优化性能
     *
     * @return UUID
     */
    public static String getUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long lsb = random.nextLong();
        long msb = random.nextLong();
        byte[] buf = new byte[32];
        int radix = 1 << 4;
        formatUnsignedLong(lsb, radix, buf, 20, 12);
        formatUnsignedLong(lsb >>> 48, radix, buf, 16, 4);
        formatUnsignedLong(msb, radix, buf, 12, 4);
        formatUnsignedLong(msb >>> 16, radix, buf, 8, 4);
        formatUnsignedLong(msb >>> 32, radix, buf, 0, 8);
        return new String(buf, StandardCharsets.UTF_8);
    }

    private static void formatUnsignedLong(Long value, int radix, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int mask = radix - 1;
        Long tempValue = value;
        do {
            charPos -= 1;
            buf[charPos] = DIGITS[tempValue.intValue() & mask];
            tempValue >>>= 4;
        } while (charPos > offset);
    }
}
