package com.geoway.atlas.web.api.v2.pool;

/**
 * 处理不同数据库的方言
 *
 * @author zhaotong 2023/7/7 14:32
 */
public interface DBDialect {

    /**
     * 获取jdbc的url
     *
     * @param ipAndPort ip和端口
     * @param dbName    数据库名称
     * @return 返回jdbc连接参数
     */
    String getJdbcUrl(String ipAndPort, String dbName);

    /**
     * 获取驱动类名称
     *
     * @return 返回驱动类名称
     */
    String getDriverClassName();
}
