package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.function.parser.common.QualifiedName;
import com.geoway.atlas.web.api.v2.exception.AtlasException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2024/12/23 16:08
 */
public class SumAreaFunctionPlan extends AssignFunctionPlan {

    private int precision = -1;

    @Override
    public String functionName() {
        return "sum_area";
    }

    @Override
    public void setArgs(Object[] args) {
        if(args == null || args.length == 0){
            throw new AtlasException("请输入重算面积字段名称");
        }else{
            boolean finish = false;
            for (Object arg : args) {
                if(finish){
                    throw new AtlasException("检查到输入参数数量不匹配！");
                }

                if(arg instanceof QualifiedName){
                    computeFields.add((QualifiedName) arg);
                }else {
                    try {
                        precision = (Integer) arg;
                        finish = true;
                    } catch (ClassCastException cce) {
                        throw new AtlasException("请检查输入参数，仅支持整数类型的精度！");
                    }
                }
            }
        }
    }

    @Override
    public boolean needRepair() {
        return true;
    }

    @Override
    public List<String> unusedFields(List<String> fields, Map<String, String> assignFieldMap) {
        List<String> result = new ArrayList<>(fields);
        if(!getLeftRecomputeFields().isEmpty()){
            result.removeAll(getLeftRecomputeFields());
        }

        if(!getRightRecomputeFields().isEmpty()){
            result.removeAll(getAssignFieldsWithSuffix(getRightRecomputeFields()));
        }
        return result;
    }

    @Override
    public String getStatisticSql(String middleLayer, Collection<String> assignFields, String oidField) {
        /**
         * 不做操作
         */
        return middleLayer;
    }

    @Override
    protected String getAssignSelectSql(String statisticViewAlias, Map<String, String> assignFieldMaps) {
        if(computeFields.size() != assignFieldMaps.size()){
            throw new AtlasException("请检查重算面积字段个数，必须与赋值字段个数一致");
        }
        List<String> sqls = new ArrayList<>();
        int i = 0;
        for(String assignField: assignFieldMaps.keySet()){
            String areaName = getFieldNameInLayer(computeFields.get(i));
            String sql;
            if(precision < 0){
                sql = String.format("sum(%s.`%s`) as %s", statisticViewAlias, areaName, assignFieldMaps.get(assignField));
            }else {
                sql = String.format("round(sum(%s.`%s`), %d) as %s", statisticViewAlias, areaName, precision, assignFieldMaps.get(assignField));
            }
            sqls.add(sql);
        }

        return String.join(", ", sqls);
    }

    @Override
    protected String getDefaultValExpr(String viewName, String fieldName) {
        String defaultValue = defaultValueMap.get(fieldName);
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }

    @Override
    protected String getUndefineValExpr(String viewName, String fieldName) {
        // 默认值为0.0
        String defaultValue = "0.0";
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }
}
