/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.rpc;

import com.geoway.atlas.data.vector.spark.common.rpc.client.SparkRpcClientApi;
import com.geoway.atlas.web.api.v2.domain.rpc.ConnectInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Component;

@Component
public class RpcClientProxy {
    @Autowired
    private ApplicationArguments arguments;
    private SparkRpcClientApi sparkRpcClientApi;
    @Autowired
    @Qualifier(value="rpcClientPool")
    private ExecutorService rpcClientPool;

    public void init(ConnectInfo connectInfo) {
        if (StringUtils.isNotBlank((CharSequence)connectInfo.getIp())) {
            this.sparkRpcClientApi = new SparkRpcClientApi(connectInfo.getIp(), connectInfo.getPort().intValue(), this.rpcClientPool);
        } else {
            String defaultAddress;
            try {
                defaultAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                defaultAddress = "127.0.0.1";
            }
            this.sparkRpcClientApi = new SparkRpcClientApi(defaultAddress, connectInfo.getPort().intValue(), this.rpcClientPool);
        }
    }

    public SparkRpcClientApi getSparkRpcClientApi() {
        return this.sparkRpcClientApi;
    }
}

