package com.geoway.atlas.web.api.v2.controller;

import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.ProcessServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.RequestUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/**
 * 数据接口
 *
 * @author zhaotong 2022/9/7 16:53
 */

@Api(value = "Atlas数据处理相关接口", tags = "数据处理")
@RequestMapping("/api/v2/process")
@RestController
@CrossOrigin(
        origins = {"*"}
)
public class ProcessController {

    @Autowired
    private ProcessServer processServer;


    @ApiOperation("无数据源执行接口")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "processName", value = "设置执行器名称", required = true),
            @ApiImplicitParam(name = "atlas_data_save_name", value = "结果数据名称"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @GetMapping(value = {"/nil/vector/{processName}"}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> nilProcess(
            @PathVariable String processName,
            @RequestParam(value = "atlas_data_save_name") String resultName,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps, Collections.singletonList("atlas.data.save.name"));
        return processServer.nilProcess(processName, paramMaps, resultName, nTaskId, jobId);
    }


    @ApiOperation("单数据源执行接口")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "processName", value = "设置执行器名称", required = true),
            @ApiImplicitParam(name = "atlas_data_base_name", value = "需要操作数据名称"),
            @ApiImplicitParam(name = "atlas_data_save_name", value = "结果数据名称"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @GetMapping(value = {"/unitary/vector/{processName}"}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> unitaryProcess(
            @PathVariable String processName,
            @RequestParam(value = "atlas_data_base_name") String baseName,
            @RequestParam(value = "atlas_data_save_name") String resultName,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.name",
                        "atlas.data.save.name"));
        return processServer.unitaryProcess(
                baseName, processName, paramMaps,
                resultName, nTaskId, jobId);
    }


    @ApiOperation("双数据源执行接口")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "processName", value = "设置执行器名称", required = true),
            @ApiImplicitParam(name = "atlas_data_base_name", value = "基础数据名称"),
            @ApiImplicitParam(name = "atlas_data_other_name", value = "其他图层数据名称"),
            @ApiImplicitParam(name = "atlas_data_save_name", value = "结果数据名称"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @GetMapping(value = {"/binary/vector/{processName}"}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> unitaryProcess(
            @PathVariable String processName,
            @RequestParam(value = "atlas_data_base_name") String baseName,
            @RequestParam(value = "atlas_data_other_name") String otherName,
            @RequestParam(value = "atlas_data_save_name") String resultName,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.name",
                        "atlas.data.other.name",
                        "atlas.data.save.name"));
        return processServer.binaryProcess(
                baseName, otherName,
                processName, paramMaps,
                resultName, nTaskId, jobId);
    }

    @ApiOperation("多数据源执行接口")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "processName", value = "设置执行器名称", required = true),
            @ApiImplicitParam(name = "atlas_data_base_name_array", value = "数据列表"),
            @ApiImplicitParam(name = "atlas_data_save_name", value = "结果数据名称"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @GetMapping(value = {"/list/vector/{processName}"}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> listProcess(
            @PathVariable String processName,
            @RequestParam(value = "atlas_data_base_name_array") String nameArray,
            @RequestParam(value = "atlas_data_save_name") String resultName,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.name.array",
                        "atlas.data.save.name"));
        return processServer.listProcess(
                nameArray, processName, paramMaps,
                resultName, nTaskId, jobId);
    }


}
