package com.geoway.atlas.web.api.v2.controller.pkg;

import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.pkg.SpatialAnalysisServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Map;

/**
 * @author zhaotong 2022/10/31 11:32
 */
@Api(value = "空间分析组合算子", tags = "空间分析组合算子")
@RequestMapping("/api/v2/package/analysis/vector")
@RestController
@CrossOrigin(
        origins = {"*"}
)
public class SpatialAnalysisController {

    @Autowired
    private SpatialAnalysisServer spatialAnalysisServer;

    @ApiOperation("相交")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_suffix", value = "基础图层的后缀"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置其他图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置其他图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_right_suffix", value = "其他图层的后缀"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/intersection"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> intersectionProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_suffix", required = false) String baseSuffix,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_right_suffix", required = false) String otherSuffix,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.intersectionProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("裁切")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置其他图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置其他图层筛选信息"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/clip"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> clipProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.clipProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("联合")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_suffix", value = "基础图层的后缀"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置联合图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置联合图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_right_suffix", value = "联合图层的后缀"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_right_recompute_fields", value = "联合图层的重算面积"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_identity_name", value = "叠加标识名称"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/union"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> unionProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_suffix", required = false) String baseSuffix,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_right_suffix", required = false) String otherSuffix,
            @RequestParam(value = "atlas_process_vector_common_intersection_right_recompute_fields", required = false) String recomputeUnionFields,
            @RequestParam(value = "atlas_process_vector_common_intersection_relation_name", required = false) String relationName,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.process.vector.common.intersection.right.recompute.fields",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                                "jobid"));
        return spatialAnalysisServer.unionProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                StringUtils.lowerCase(recomputeUnionFields),
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("标识")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_suffix", value = "基础图层的后缀"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置联合图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置联合图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_right_suffix", value = "联合图层的后缀"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_identity_name", value = "叠加标识名称"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/identity"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> identityProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_suffix", required = false) String baseSuffix,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_right_suffix", required = false) String otherSuffix,
            @RequestParam(value = "atlas_process_vector_common_intersection_right_recompute_fields", required = false) String recomputeOtherFields,
            @RequestParam(value = "atlas_process_vector_common_intersection_relation_name", required = false) String relationName,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.process.vector.common.intersection.right.recompute.fields",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.identityProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                StringUtils.lowerCase(recomputeOtherFields),
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("擦除")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置其他图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置其他图层筛选信息"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/erase"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> eraseProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.eraseProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("更新")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_intersection_left_recompute_fields", value = "基础图层的重算面积"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置其他图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置其他图层筛选信息"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/update"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> updateProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_vector_common_intersection_left_recompute_fields", required = false) String recomputeBaseFields,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.filter",
                        "atlas.process.vector.common.intersection.left.recompute.fields",
                        "atlas.data.other.identity",
                        "atlas.data.other.filter",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.updateProcess(
                baseIdentity,
                baseFilter,
                StringUtils.lowerCase(recomputeBaseFields),
                otherIdentity,
                otherFilter,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("融合")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_dissolve_group_fields", value = "融合分组字段", required = true),
            @ApiImplicitParam(name = "atlas_process_dissolve_sum_fields", value = "数值累加字段"),
            @ApiImplicitParam(name = "atlas_process_dissolve_distinct_fields", value = "属性合并字段"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/dissolve"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> dissolveProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_dissolve_group_fields") String groupFields,
            @RequestParam(value = "atlas_process_dissolve_sum_fields", required = false) String sumFields,
            @RequestParam(value = "atlas_process_dissolve_distinct_fields", required = false) String distinctFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.dissolveProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("去重")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_distinct_recompute_fields", value = "重算面积字段", required = false),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/distinct"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> distinctProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_distinct_recompute_fields") String recomputeFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        return spatialAnalysisServer.distinctProcess(
                baseIdentity,
                recomputeFields,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("连通性分析")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_connected_components_field_name", value = "分组字段"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/connectivity"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> connectivityProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_connected_components_field_name", required = false) String connectedField,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.connectivityProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("缓冲")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_buffer_distance", value = "缓冲距离", required = true),
            @ApiImplicitParam(name = "atlas_process_buffer_side_type", value = "侧类型"),
            @ApiImplicitParam(name = "atlas_process_buffer_end_type", value = "末端类型"),
            @ApiImplicitParam(name = "atlas_process_buffer_dissolve_type", value = "融合类型"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/buffer"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> bufferProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_buffer_distance") String distance,
            @RequestParam(value = "atlas_process_buffer_side_type", required = false) String sideType,
            @RequestParam(value = "atlas_process_buffer_end_type", required = false) String endType,
            @RequestParam(value = "atlas_process_buffer_dissolve_type", required = false) String dissolveType,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.process.buffer.dissolve.type",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.bufferProcess(
                baseIdentity,
                paramMaps,
                dissolveType,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("网格剖分")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_mode", value = "网格剖分模式", defaultValue = "0", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_param", value = "网格剖分参数", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_field", value = "编码字段名称"),
            @ApiImplicitParam(name = "atlas_process_grid_split_recompute_fields", value = "重算字段名称"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/grid-split"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> gridSplit(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_grid_split_mode", defaultValue = "0") String splitMode,
            @RequestParam(value = "atlas_process_grid_split_code_param") String codeParams,
            @RequestParam(value = "atlas_process_grid_split_code_field", required = false) String codeField,
            @RequestParam(value = "atlas_process_grid_split_recompute_fields", required = false) String recomputeFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.process.buffer.dissolve.type",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return spatialAnalysisServer.gridSplit(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("叠加赋值")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_base_filter", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置叠加图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_other_filter", value = "设置叠加图层筛选信息"),
            @ApiImplicitParam(name = "atlas_process_vector_common_assign_fields", value = "赋值字段", required = true),
            @ApiImplicitParam(name = "atlas_process_vector_common_assign_type", value = "赋值类型", defaultValue = "max"),
            @ApiImplicitParam(name = "atlas_process_vector_common_assign_consider_null", value = "空值是否参与赋值", defaultValue = "true"),
            @ApiImplicitParam(name = "atlas_process_vector_common_assign_default", value = "默认值"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/assign"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> assignProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_filter", required = false) String baseFilter,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_data_other_filter", required = false) String otherFilter,
            @RequestParam(value = "atlas_process_vector_common_assign_fields") String assignFields,
            @RequestParam(value = "atlas_process_vector_common_assign_type", required = false, defaultValue = "max") String assignType,
            @RequestParam(value = "atlas_process_vector_common_assign_consider_null", required = false, defaultValue = "true") boolean considerNull,
            @RequestParam(value = "atlas_process_vector_common_assign_default", required = false) String defaultValues,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        return spatialAnalysisServer.assignProcess(
                baseIdentity,
                baseFilter,
                otherIdentity,
                otherFilter,
                StringUtils.lowerCase(assignFields),
                assignType,
                considerNull,
                defaultValues,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

}
