package com.geoway.atlas.web.api.v2.pool;

import com.zaxxer.hikari.pool.HikariPool;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Hikari连接池信息
 *
 * @author zhaotong 2023/7/12 14:35
 */
public class HikariPoolInfo {

    /**
     * 连接池
     */
    private HikariPool hikariPool;

    /**
     * 最后访问时间，如果为-1表示程序在运行中
     */
    private long lastAccessTime = -1L;


    private AtomicLong connectCount = new AtomicLong(0);

    /**
     * 关闭连接池时加锁
     */
    private ReentrantLock reentrantLock = new ReentrantLock();

    /**
     * 条件变量
     */
    private Condition condition = reentrantLock.newCondition();

    /**
     * 是否正在关闭连接池
     */
    private boolean cleaning;

    public HikariPoolInfo() {
    }

    public HikariPoolInfo(HikariPool hikariPool) {
        this.hikariPool = hikariPool;
    }

    public ReentrantLock getReentrantLock() {
        return reentrantLock;
    }

    public Condition getCondition() {
        return condition;
    }

    public HikariPool getHikariPool() {
        return hikariPool;
    }

    public void setHikariPool(HikariPool hikariPool) {
        this.hikariPool = hikariPool;
    }

    public long getLastAccessTime() {
        return lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isCleaning() {
        return cleaning;
    }

    public void setCleaning(boolean cleaning) {
        this.cleaning = cleaning;
    }

    public long startConnection() {
        return this.connectCount.incrementAndGet();
    }

    public long endConnection() {
        return this.connectCount.decrementAndGet();
    }

    public long getConnectionCount() {
        return this.connectCount.get();
    }

}
