package com.geoway.atlas.web.api.v2.service.impl;

import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.service.ProcessServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhaotong 2022/9/14 20:02
 */
@Service
public class ProcessServerImpl implements ProcessServer {

    @Autowired
    private RpcClientProxy client;

    @Autowired
    private Constants constants;

    @Override
    public Map<String, Object> nilProcess(String processName,
                                          Map<String, String> processParams,
                                          String resultName,
                                          String taskId,
                                          String jobId) {

        String message = client.getSparkRpcClientApi().nilProcess(
                processName, processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);
        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public Map<String, Object> unitaryProcess(String atlasDataName,
                                              String processName, Map<String, String> processParams,
                                              String resultName,
                                              String taskId, String jobId) {

        String message = client.getSparkRpcClientApi().unitaryProcess(
                AtlasTagUtils.getAtlasRpcDataTag(atlasDataName),
                processName, processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);

        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public Map<String, Object> binaryProcess(String baseName,
                                             String otherDataName,
                                             String processName, Map<String, String> processParams,
                                             String resultName,
                                             String taskId, String jobId) {

        String message = client.getSparkRpcClientApi().binaryProcess(
                AtlasTagUtils.getAtlasRpcDataTag(baseName),
                AtlasTagUtils.getAtlasRpcDataTag(otherDataName),
                processName, processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);

        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public Map<String, Object> listProcess(String atlasDataNames,
                                           String processName, Map<String, String> processParams,
                                           String resultName,
                                           String taskId, String jobId) {

        List<AtlasRpcDataTag> rpcDataTags =
                Arrays.stream(StringUtils.split(atlasDataNames, ","))
                        .map(AtlasTagUtils::getAtlasRpcDataTag)
                        .collect(Collectors.toList());
        String message = client.getSparkRpcClientApi().listProcess(
                rpcDataTags,
                processName, processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);

        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public String filterProcess(String atlasDataName,
                                Map<String, String> processParams,
                                String resultName,
                                String taskId,
                                String jobId) {
        return client.getSparkRpcClientApi().unitaryProcess(
                AtlasTagUtils.getAtlasRpcDataTag(atlasDataName),
                constants.filterProcessName(), processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);
    }

    @Override
    public String calculatorProcess(
            String atlasDataName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId) {
        return client.getSparkRpcClientApi().unitaryProcess(
                AtlasTagUtils.getAtlasRpcDataTag(atlasDataName),
                constants.calculateProcessName(), processParams,
                AtlasTagUtils.getAtlasRpcDataTag(resultName),
                taskId, jobId);
    }
}
