package com.geoway.atlas.web.api.v2.utils;

/**
 * @author zhaotong 2022/9/14 17:24
 */
public class UrlUtils {

    private static final String[] URL_ESCAPEDS =
            new String[]{"+", " ", "?", "%", "#", "&", "="};

    private static final String[] URL_REPLACES =
            new String[]{"%2B", "%20", "%3F", "%25", "%23", "%26", "%3D"};

    private static final String CHINESE_REGEX = "[\u4e00-\u9fa5]";


    public static String escaped(String rawUrl) {
        String result = rawUrl;
        for (int escapedIndex = 0; escapedIndex < URL_ESCAPEDS.length; escapedIndex++) {
            result = result.replace(URL_ESCAPEDS[escapedIndex], URL_REPLACES[escapedIndex]);
        }
        return result;
    }
}
