package com.geoway.atlas.web.api.v2.config;

import com.geoway.atlas.web.api.v2.job.TaskDetialMonitor;
import com.geoway.atlas.web.api.v2.pool.DBPoolMonitor;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhaotong 2023/1/5 9:06
 */

@Configuration
public class QuartzConfig {
    public static final JobKey REMOVE_DBPOOL =
            new JobKey("removeDbPool", "Atlas-Gis-toolkit");

    public static final JobKey REMOVE_TASKS =
            new JobKey("removeTasks", "Atlas-Gis-toolkit");

    @Bean("removeDbPoolDetial")
    public JobDetail getRemoveDbPoolDetial() {
        return JobBuilder.newJob(DBPoolMonitor.class)
                .storeDurably(true)
                .withIdentity(REMOVE_DBPOOL)
                .build();
    }

    @Bean("removeDbPoolTrigger")
    public Trigger getRemoveDbPoolTrigger() {
        return TriggerBuilder.newTrigger()
                .forJob(REMOVE_DBPOOL)
                .withSchedule(SimpleScheduleBuilder
                        .simpleSchedule()
                        .withIntervalInSeconds(30)
                        .repeatForever())
                .build();
    }

    @Bean("removeTaskDetial")
    public JobDetail getRemoveTaskDetial() {
        return JobBuilder.newJob(TaskDetialMonitor.class)
                .storeDurably(true)
                .withIdentity(REMOVE_TASKS)
                .build();
    }

    @Bean("removeTaskTrigger")
    public Trigger getRemoveTaskTrigger() {
        return TriggerBuilder.newTrigger()
                .forJob(REMOVE_TASKS)
                .withSchedule(SimpleScheduleBuilder
                        .simpleSchedule()
                        .withIntervalInMinutes(2)
                        .repeatForever())
                .build();
    }
}
