package com.geoway.atlas.web.api.v2.license.jna;

import java.io.*;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;

public class NativeLoader {
    final private static boolean isWindows = OSInfo.isWindows();

    public static String initializeLibrary(String libName) {
        final String sqliteNativeLibraryName = System.mapLibraryName(libName);
//        System.out.println("sqlite nativelibrary name : " + sqliteNativeLibraryName);
        final String sqliteNativeLibraryPath = "/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
//        System.out.println("sqlite nativelibrary path : " + sqliteNativeLibraryPath);
        if (NativeLoader.class.getResource(sqliteNativeLibraryPath + "/" + sqliteNativeLibraryName) == null) {
            return null;
        }
        final String tempFolder =
                (isWindows) ? new File(System.getProperty("java.io.tmpdir")).getAbsolutePath() : "/tmp";
//                new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        System.out.println("tmpdir : " + tempFolder);
        try {
            return extractLibraryFile(sqliteNativeLibraryPath, sqliteNativeLibraryName, tempFolder);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String extractLibraryFile(final String libFolderForCurrentOS, final String libraryFileName, final String targetFolder) throws IOException {
        final String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        final String prefix = "license-" + getVersion() + "-" + OSInfo.getArchName() + "-";
        final String extractedLibFileName = libraryFileName;
        final File extractedLibFile = new File(targetFolder, extractedLibFileName);
//        System.out.println("ExtractedLibFile : " + extractedLibFile.getAbsolutePath());
        if (extractedLibFile.exists()) {
//            System.out.println("ExtractedLib exist ! 判断md5，相同则保留，不同则删除");
            final String md5sum1 = md5sum(NativeLoader.class.getResourceAsStream(nativeLibraryFilePath));
            final String md5sum2 = md5sum(new FileInputStream(extractedLibFile));
            if (md5sum1.equals(md5sum2)) {
                return extractedLibFile.getAbsolutePath();
            }
            final boolean deletionSucceeded = extractedLibFile.delete();
            if (!deletionSucceeded) {
                throw new IOException("failed to remove existing standalone library file: " + extractedLibFile.getAbsolutePath());
            }
        }
//        System.out.println("将jar中的so拷贝到系统ExtractedLibFile路径中");
        final InputStream reader = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
        final FileOutputStream writer = new FileOutputStream(extractedLibFile);
        final byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
        writer.close();
        reader.close();
        if (!System.getProperty("os.name").contains("Windows")) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "755", extractedLibFile.getAbsolutePath()}).waitFor();
            } catch (Throwable t) {
            }
        }
        return extractedLibFile.getAbsolutePath();
    }

    static String md5sum(final InputStream input) throws IOException {
        final BufferedInputStream in = new BufferedInputStream(input);
        try {
            final MessageDigest digest = MessageDigest.getInstance("MD5");
            final DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            final ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            return md5out.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm is not available: " + e);
        } finally {
            in.close();
        }
    }

    public static String getVersion() {
        final URL versionFile = NativeLoader.class.getResource("/META-INF/maven/com.geoway.gspark/license/pom.properties");
        String version = "unknown";
        try {
            if (versionFile != null) {
                final Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                version = version.trim().replaceAll("[^0-9\\.]", "");
            }
        } catch (IOException e) {
            System.err.println(e);
        }
        return version;
    }
}
