package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.function.parser.common.FunctionParserUtils;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2024/12/23 16:27
 */
public class ConditionRate extends AssignFunctionPlan{

    private double rateValue = -1;
    private String greaterOrEqualAssignValue = null;
    private String lessAssignValue = null;

    @Override
    public String functionName() {
        return "condition_rate";
    }

    @Override
    public boolean needRepair() {
        return true;
    }

    @Override
    public List<String> unusedFields(List<String> fields, Map<String, String> assignFieldMap) {
        List<String> removeFields = new ArrayList<>(fields);
        removeFields.remove(baseShapeAreaName);
        return removeFields;
    }

    @Override
    public String getStatisticSql(String middleLayer, Collection<String> assignFields, String oidField) {
        /**
         * 不做操作
         */
        return middleLayer;
    }

    @Override
    public void setArgs(Object[] args) {
        if(args.length == 3){
            rateValue = FunctionParserUtils.getDouble(args[0], "请检查输入比例阈值，仅支持数值类型！");
            try{
                lessAssignValue = FunctionParserUtils.getStrExprWithNull(args[1]);
            }catch (ClassCastException cce){
                throw new AtlasException("请检查小于阈值赋值类型，仅支持字符串类型！");
            }

            try{
                greaterOrEqualAssignValue = FunctionParserUtils.getStrExprWithNull(args[2]);
            }catch (ClassCastException cce){
                throw new AtlasException("请检查大于等于阈值赋值类型，仅支持字符串类型！");
            }
        }else {
            throw new AtlasException("输入参数个数错误!");
        }
    }

    @Override
    protected String getAssignSelectSql(String statisticViewAlias, Map<String, String> assignFieldMaps) {

        if(assignFieldMaps.size() > 1){
            throw new AtlasException("请检查输入参数，条件比例赋值仅支持单个字段！");
        }

        String rateSql = String.format("sum(%s.%s) / first_value(%s.%s)",
                statisticViewAlias, intersectShapeAreaName, statisticViewAlias, baseShapeAreaName);

//        String lessValueSql = (lessAssignValue != null) ? "'"+lessAssignValue+"'" : "null";
//        String greaterOrEqualAssignValueSql = (greaterOrEqualAssignValue != null) ? "'"+greaterOrEqualAssignValue+"'" : "null";
//
//        List<String> sqls = new ArrayList<>();
//        for(String key: assignFieldMaps.keySet()){
//            String caseWhenSql = String.format("(case when %s < %f then %s else %s end ) as %s",
//                    rateSql, rateValue, lessValueSql, greaterOrEqualAssignValueSql, assignFieldMaps.get(key));
//            sqls.add(caseWhenSql);
//        }

        // 将比例添加到结果中方便后续计算
        return rateSql + " as " + RATE_NAME;
    }

    @Override
    protected String getDefaultValExpr(String viewName, String fieldName) {
        // 根据比例给每个字段赋值
//        return String.format("case when %s.%s is null then %s else %s.%s end as %s",
//                viewName, RATE_NAME, defaultValueMap.get(fieldName), viewName, fieldName, fieldName);
        throw new AtlasException("未使用此方法");
    }

    @Override
    protected String getUndefineValExpr(String viewName, String fieldName) {
        throw new AtlasException("未使用此方法");
    }

    @Override
    public String getFieldSelectWithDefExpr(String viewName, Collection<String> valueSet) {
        String lessValueSql = (lessAssignValue != null) ? lessAssignValue : "null";
        String greaterOrEqualAssignValueSql = (greaterOrEqualAssignValue != null) ? greaterOrEqualAssignValue : "null";

//        String.format(
//                "(case when %s.%s is not null and %s.%s < %f then %s else %s end ) as %s",
//                viewName, RATE_NAME, rateValue, lessValueSql, greaterOrEqualAssignValueSql, assignFieldMaps.get(key));
        List<String> sqlList = new ArrayList<>();
        for(String fieldName:valueSet){
            String nullValue;
            if(defaultValueMap.containsKey(fieldName) && StringUtils.isNotBlank(defaultValueMap.get(fieldName))){
                // 如果默认值不为空则null值为默认值
                nullValue = defaultValueMap.get(fieldName);
            }else {
                // 如果默认值为空则null值为小于阈值赋的值
                nullValue = lessValueSql;
            }

            sqlList.add(String.format(
                    "(case when %s.%s is null then %s " + // 如果赋值比例为空则说明没有叠上，需要取默认值，如果没有默认值按照小于阈值处理
                            "else case when %s.%s < %f then %s else %s end " + // 如果赋值比例小于阈值则赋lessValueSql，否则赋greaterOrEqualAssignValueSql
                            "end) as %s",
                    viewName, RATE_NAME, nullValue, viewName, RATE_NAME, rateValue, lessValueSql, greaterOrEqualAssignValueSql,fieldName));
        }
        return String.join(", ", sqlList);
    }
}
