/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.config;

import com.geoway.atlas.web.api.v2.job.TaskDetialMonitor;
import com.geoway.atlas.web.api.v2.pool.DBPoolMonitor;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class QuartzConfig {
    public static final JobKey REMOVE_DBPOOL = new JobKey("removeDbPool", "Atlas-Gis-toolkit");
    public static final JobKey REMOVE_TASKS = new JobKey("removeTasks", "Atlas-Gis-toolkit");

    @Bean(value={"removeDbPoolDetial"})
    public JobDetail getRemoveDbPoolDetial() {
        return JobBuilder.newJob(DBPoolMonitor.class).storeDurably(true).withIdentity(REMOVE_DBPOOL).build();
    }

    @Bean(value={"removeDbPoolTrigger"})
    public Trigger getRemoveDbPoolTrigger() {
        return TriggerBuilder.newTrigger().forJob(REMOVE_DBPOOL).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(30).repeatForever()).build();
    }

    @Bean(value={"removeTaskDetial"})
    public JobDetail getRemoveTaskDetial() {
        return JobBuilder.newJob(TaskDetialMonitor.class).storeDurably(true).withIdentity(REMOVE_TASKS).build();
    }

    @Bean(value={"removeTaskTrigger"})
    public Trigger getRemoveTaskTrigger() {
        return TriggerBuilder.newTrigger().forJob(REMOVE_TASKS).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(2).repeatForever()).build();
    }
}

