/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.pool;

import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import com.geoway.atlas.web.api.v2.config.HikariPoolConfig;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import com.geoway.atlas.web.api.v2.pool.DBDialect;
import com.geoway.atlas.web.api.v2.pool.HikariPoolInfo;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPool {
    private static final String JDBC = "jdbc";
    private static final Pattern DB_PATTERN = Pattern.compile("^(.*?)://((.*?)/(.*)@)?(.*?)((/(.*?))(\\?.*|$))");
    private static final Logger log = LoggerFactory.getLogger(DBPool.class);
    private static final long CLOSE_POOL_TIMEOUT_MS = 120000L;
    private static final ConcurrentMap<String, HikariPoolInfo> POOL = new ConcurrentHashMap<String, HikariPoolInfo>();

    public static <T> T executeQuery(String dbInfo, String sql, Function<ResultSet, T> convertFunction) {
        return DBPool.executeQuery(dbInfo, sql, convertFunction, null);
    }

    public static <T> T executeQuery(String dbInfo, String sql, Function<ResultSet, T> convertFunction, Map<Object, Object> extraProperties) {
        DBPool.waitForRun(dbInfo);
        HikariPoolInfo hikariPoolInfo = POOL.computeIfAbsent(dbInfo, k -> new HikariPoolInfo(new HikariPool(DBPool.getHikariConfig(k, extraProperties))));
        hikariPoolInfo.startConnection();
        Connection connection = null;
        try {
            connection = hikariPoolInfo.getHikariPool().getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            T t = convertFunction.apply(resultSet);
            return t;
        }
        catch (SQLException e) {
            log.error("\u6267\u884c:" + sql + ",\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    log.error("\u56de\u6eda\u5931\u8d25!");
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            hikariPoolInfo.endConnection();
            hikariPoolInfo.setLastAccessTime(System.currentTimeMillis());
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error("\u91ca\u653e\u8fde\u63a5\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public static boolean execute(String dbInfo, String sql) {
        return DBPool.execute(dbInfo, sql, null);
    }

    public static boolean execute(String dbInfo, String sql, Map<Object, Object> extraProperties) {
        DBPool.waitForRun(dbInfo);
        HikariPoolInfo hikariPoolInfo = POOL.computeIfAbsent(dbInfo, k -> new HikariPoolInfo(new HikariPool(DBPool.getHikariConfig(k, extraProperties))));
        hikariPoolInfo.startConnection();
        Connection connection = null;
        try {
            connection = hikariPoolInfo.getHikariPool().getConnection();
            Statement statement = connection.createStatement();
            boolean bl = statement.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            log.error("\u6267\u884c:" + sql + ",\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    log.error("\u56de\u6eda\u5931\u8d25!");
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            hikariPoolInfo.endConnection();
            hikariPoolInfo.setLastAccessTime(System.currentTimeMillis());
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error("\u91ca\u653e\u8fde\u63a5\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public static int executeUpdate(String dbInfo, String sql) {
        return DBPool.executeUpdate(dbInfo, sql, null);
    }

    public static int executeUpdate(String dbInfo, String sql, Map<Object, Object> extraProperties) {
        DBPool.waitForRun(dbInfo);
        HikariPoolInfo hikariPoolInfo = POOL.computeIfAbsent(dbInfo, k -> new HikariPoolInfo(new HikariPool(DBPool.getHikariConfig(k, extraProperties))));
        hikariPoolInfo.startConnection();
        Connection connection = null;
        try {
            connection = hikariPoolInfo.getHikariPool().getConnection();
            Statement statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            log.error("\u6267\u884c:" + sql + ",\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    log.error("\u56de\u6eda\u5931\u8d25!");
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            hikariPoolInfo.endConnection();
            hikariPoolInfo.setLastAccessTime(System.currentTimeMillis());
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error("\u91ca\u653e\u8fde\u63a5\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeIfNotUse() {
        if (!POOL.isEmpty()) {
            for (String hikariPoolKey : POOL.keySet()) {
                HikariPoolInfo hikariPoolInfo = (HikariPoolInfo)POOL.get(hikariPoolKey);
                if (hikariPoolInfo.getConnectionCount() != 0L || System.currentTimeMillis() - hikariPoolInfo.getLastAccessTime() <= 120000L) continue;
                hikariPoolInfo.getReentrantLock().lock();
                try {
                    if (!POOL.containsKey(hikariPoolKey)) continue;
                    hikariPoolInfo.setCleaning(true);
                    try {
                        hikariPoolInfo.getHikariPool().shutdown();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    POOL.remove(hikariPoolKey);
                    hikariPoolInfo.setCleaning(false);
                    hikariPoolInfo.getCondition().signalAll();
                }
                finally {
                    hikariPoolInfo.getReentrantLock().unlock();
                }
            }
        }
    }

    public static void waitForRun(String dbInfo) {
        if (POOL.containsKey(dbInfo)) {
            HikariPoolInfo hikariPoolInfo = null;
            try {
                hikariPoolInfo = (HikariPoolInfo)POOL.get(dbInfo);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (hikariPoolInfo != null && hikariPoolInfo.isCleaning()) {
                hikariPoolInfo.getReentrantLock().lock();
                try {
                    while (hikariPoolInfo.isCleaning()) {
                        hikariPoolInfo.getCondition().await();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    hikariPoolInfo.getReentrantLock().unlock();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HikariConfig getHikariConfig(String dbInfo, Map<Object, Object> extraProperties) {
        String dbMode = StringUtils.substringBefore((String)dbInfo, (String)":");
        HashMap<String, String> connectInfo = new HashMap<String, String>();
        if (!JDBC.equalsIgnoreCase(dbMode)) throw new AtlasException("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u6570\u636e\u8fde\u63a5\u53c2\u6570\u6807\u8bc6\uff1a" + dbMode);
        String dbUrl = StringUtils.substringAfter((String)dbInfo, (String)":");
        Matcher matcher = DB_PATTERN.matcher(dbUrl);
        if (!matcher.find()) throw new AtlasException("\u8f93\u5165\u7684\u8def\u5f84\u4e0d\u89c4\u8303\uff1a" + dbInfo);
        if (matcher.groupCount() != 9) throw new AtlasException("\u8f93\u5165\u7684\u8def\u5f84\u4e0d\u89c4\u8303\uff1a" + dbInfo);
        DBDialect dbDialect = AtlasGisToolkitBeanFactory.getBean(matcher.group(1).toLowerCase(), DBDialect.class);
        String jdbcUrl = dbDialect.getJdbcUrl(matcher.group(5), matcher.group(8)) + matcher.group(9);
        connectInfo.put("driverClassName", dbDialect.getDriverClassName());
        connectInfo.put("jdbcUrl", jdbcUrl);
        connectInfo.put("username", matcher.group(3));
        connectInfo.put("password", matcher.group(4));
        Properties hikariProperties = new Properties();
        HikariPoolConfig hikariPoolConfig = AtlasGisToolkitBeanFactory.getBean(HikariPoolConfig.class);
        Map hikariMap = (Map)AtlasGisToolkitBeanFactory.getObjectMapper().convertValue((Object)hikariPoolConfig, Map.class);
        hikariProperties.putAll((Map<?, ?>)hikariMap);
        hikariProperties.putAll((Map<?, ?>)connectInfo);
        if (extraProperties == null) return new HikariConfig(hikariProperties);
        hikariProperties.putAll(extraProperties);
        return new HikariConfig(hikariProperties);
    }
}

