package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.web.api.v2.exception.AtlasException;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2024/12/23 15:28
 */
public class MaxValueFunctionPlan extends AssignFunctionPlan {

    @Override
    public String functionName() {
        return "max";
    }

    @Override
    public void setArgs(Object[] args) {
    }

    @Override
    public boolean needRepair() {
        return false;
    }

    public String getAssignFuncSql(String statisticSql, String oidField, Map<String, String> assignFieldMaps) {
        String statisticViewAlias = "a_" + FIXED_ASSIGN_LAYER_SUFFIX;
        String rowKeyName = "row_key_" + FIXED_ASSIGN_LAYER_SUFFIX;
        String sumAreaName = "sum_area_" + FIXED_ASSIGN_LAYER_SUFFIX;

        String rowKeySql = String.format("row_number() over(partition by %s.%s order by %s.%s desc) as %s",
                statisticViewAlias, oidField, statisticViewAlias, intersectShapeAreaName, rowKeyName);

        String sumAreaSql = String.format("sum(%s.%s) over(partition by %s.%s) as %s",
                statisticViewAlias, intersectShapeAreaName, statisticViewAlias, oidField, sumAreaName);

        String subSql = String.format("select %s.*, %s, %s from (%s) %s",
                statisticViewAlias, rowKeySql, sumAreaSql, statisticSql, statisticViewAlias);

        String subSqlViewAlias = "aa_" + FIXED_ASSIGN_LAYER_SUFFIX;
        List<String> assignSqlList = new ArrayList<>();
        for (Map.Entry<String, String> entry : assignFieldMaps.entrySet()) {
            String assignField = addSuffixName(entry.getKey());
            String assignFieldAlias = entry.getValue();
//            String defaultValue = defaultValueMap.getOrDefault(entry.getKey(), "");
            if(isConsiderNull){
                String assignFieldSql = String.format(
                        "case when %s.%s - %s.%s > %s.%s then null else %s.`%s` end as %s"
                        , subSqlViewAlias, baseShapeAreaName, subSqlViewAlias, sumAreaName
                        , subSqlViewAlias, intersectShapeAreaName, subSqlViewAlias, assignField, assignFieldAlias);
                assignSqlList.add(assignFieldSql);
            }else {
                String assignFieldSql = String.format(
                        "%s.`%s` as %s", subSqlViewAlias, assignField, assignFieldAlias);
                assignSqlList.add(assignFieldSql);
            }
        }

        return String.format("select %s.%s, %s from (%s) %s where %s.%s=1",
                subSqlViewAlias, oidField, String.join(", ", assignSqlList),
                subSql, subSqlViewAlias, subSqlViewAlias, rowKeyName);
    }

    @Override
    protected String getAssignSelectSql(String statisticViewAlias, Map<String, String> assignFieldMaps) {
        throw new AtlasException("未实现当前方法！");
    }

    @Override
    protected String getDefaultValExpr(String viewName, String fieldName) {
        String defaultValue = defaultValueMap.get(fieldName);
        if(!StringUtils.startsWith(defaultValue, "'")){
            defaultValue = "'" + defaultValue + "'";
        }
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }

    @Override
    protected String getUndefineValExpr(String viewName, String fieldName) {
        // 默认值为空字符串
        String defaultValue = "''";
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }
}
