/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.common.error.GSparkException;
import com.geoway.atlas.data.vector.spark.common.rpc.common.AtlasRpcServerException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ResponseBuilder {
    public static final String STATE = "state";
    public static final String ERROR = "error";
    public static final String TIMEOUT_MILLIS = "timeoutMillis";
    public static final String JOB_ID = "jobid";
    public static final String PROGRESS = "progress";
    public static final String RESULT = "result";
    public static final Integer DEFAULT_TIMEOUT_VALUE = 36000000;
    public static final String STATE_SUCCEED = "succeed";
    public static final String STATE_FAILED = "failed";
    public static final String STATE_RUNNING = "running";
    public static final String ERROR_MESSAGE = "msg";
    public static final String ERROR_DETAIL = "detail";
    public static final String ERROR_LOG = "log";

    public static Map<String, Object> buildFailed(Throwable throwable) {
        Throwable cause;
        HashMap<String, String> failedMessage = new HashMap<String, String>();
        HashMap<String, Object> errorObj = new HashMap<String, Object>();
        if (throwable instanceof CompletionException && ((cause = throwable.getCause()) instanceof GSparkException || cause instanceof AtlasRpcServerException)) {
            failedMessage.put(ERROR_MESSAGE, ExceptionUtils.getRootCauseMessage((Throwable)cause));
            failedMessage.put(ERROR_DETAIL, StringUtils.join((Object[])ExceptionUtils.getRootCauseStackTrace((Throwable)cause), (String)"\n\t"));
        }
        if (failedMessage.isEmpty()) {
            failedMessage.put(ERROR_MESSAGE, ExceptionUtils.getRootCauseMessage((Throwable)throwable));
            failedMessage.put(ERROR_DETAIL, StringUtils.join((Object[])ExceptionUtils.getRootCauseStackTrace((Throwable)throwable), (String)"\n\t"));
        }
        errorObj.put(STATE, STATE_FAILED);
        errorObj.put(ERROR, failedMessage.get(ERROR_MESSAGE).toString());
        errorObj.put(ERROR_LOG, failedMessage);
        return errorObj;
    }

    public static Map<String, Object> buildRunning(String jobId) {
        HashMap<String, Object> responseObj = new HashMap<String, Object>();
        responseObj.put(STATE, STATE_RUNNING);
        responseObj.put(PROGRESS, 50);
        return responseObj;
    }

    public static Map<String, Object> buildSuccess(Object message) {
        HashMap<String, Object> responseObj = new HashMap<String, Object>();
        responseObj.put(STATE, STATE_SUCCEED);
        responseObj.put(RESULT, message);
        return responseObj;
    }

    public static Map<String, Object> buildAsyncResponse(String jobId) {
        HashMap<String, Object> responseObj = new HashMap<String, Object>();
        responseObj.put(STATE, STATE_RUNNING);
        responseObj.put(JOB_ID, jobId);
        responseObj.put(TIMEOUT_MILLIS, DEFAULT_TIMEOUT_VALUE);
        return responseObj;
    }
}

