package com.geoway.atlas.function.parser.common;

import com.geoway.atlas.web.api.v2.exception.AtlasException;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * @author zhaotong 2024/12/19 18:31
 */
public class FunctionPlanFactory {

    /**
     * 加载执行方法
      * @param functionName 方法名称
     * @param args 方法参数
     * @return 返回方法
     */
    public static FunctionPlan getFunctionPlan(String functionName, Object[] args) {
        ServiceLoader<FunctionPlan> serviceLoader = ServiceLoader.load(FunctionPlan.class);
        List<String> functionNames = new ArrayList<>();
        for (FunctionPlan functionPlan : serviceLoader) {
            functionNames.add(functionPlan.functionName());
            if (functionPlan.functionName().equalsIgnoreCase(functionName)) {
                functionPlan.setArgs(args);
                return functionPlan;
            }
        }

        throw new AtlasException(String.format("不支持当前的方法：%s, 支持的方法列表：%s",
                functionName, String.join(",", functionNames)));

    }

}
