package com.geoway.atlas.web.api.v2.component.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.google.protobuf.util.JsonFormat;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zhaotong 2022/10/13 0:14
 */

@JsonComponent
public class AtlasRpcDataTagSerializer extends StdSerializer<AtlasRpcDataTag> {

    private static final String DATA_NAME = "dataName";
    private static final String DATA_LABEL = "dataLabel";

    private static final String NAME_SPACE = "nameSpace";
    private static final String LOCAL_NAME = "localName";

    protected AtlasRpcDataTagSerializer() {
        super(AtlasRpcDataTag.class);
    }

    @Override
    public void serialize(AtlasRpcDataTag atlasRpcDataTag, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Map<String, Object> atlasDataTag = new HashMap<>();
        Map<String, Object> atlasDataName = new HashMap<>();
        AtlasRpcDataName rpcDataName = atlasRpcDataTag.getDataName();

        atlasDataName.put(NAME_SPACE, (StringUtils.isNotBlank(rpcDataName.getNameSpace()) ? rpcDataName.getNameSpace() : ""));
        atlasDataName.put(LOCAL_NAME, rpcDataName.getLocalName());
        atlasDataTag.put(DATA_NAME, atlasDataName);

        if (!atlasRpcDataTag.getDataLabelMap().isEmpty()) {
            atlasDataTag.put(DATA_LABEL, atlasRpcDataTag.getDataLabelMap());
        }

        jsonGenerator.writeObject(atlasDataTag);
    }
}
