package com.geoway.atlas.web.api.v2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaotong 2022/9/6 15:33
 */

@Api(value = "服务心跳接口", tags = "服务心跳")
@RestController
@RequestMapping("/api/v2")
@CrossOrigin(
        origins = {"*"}
)
public class HeartBeatController {

    @ApiOperation("判断服务是否存活")
    @GetMapping(value = {"/"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public String isAlive() {
        return "Server is Running!";
    }

}
