package com.geoway.atlas.web.api.v2.controller.pkg;

import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.pkg.SpatialStatisticServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Map;

/**
 * @author zhaotong 2022/10/31 11:32
 */
@Api(value = "空间统计组合算子", tags = "空间统计组合算子")
@RequestMapping("/api/v2/package/statistic")
@RestController
@CrossOrigin(
        origins = {"*"}
)
public class SpatialStatisticController {

    @Autowired
    private SpatialStatisticServer spatialStatisticServer;

    @Autowired
    private Constants constants;

    @ApiOperation("面积计算")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_calculate_new_name", value = "设置计算后的新字段名称"),
            @ApiImplicitParam(name = "atlas_process_calculate_is_new", value = "设置计算后的字段是否为新增字段"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/st_area"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> stAreaProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_calculate_new_name") String calculateName,
            @RequestParam(value = "atlas_process_calculate_is_new") String isNewField,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        paramMaps.put(constants.calculateTarget(), constants.calculateTargetStArea());
        return spatialStatisticServer.calculateProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("椭球面积计算")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_calculate_new_name", value = "设置计算后的新字段名称"),
            @ApiImplicitParam(name = "atlas_process_calculate_is_new", value = "设置计算后的字段是否为新增字段"),
            @ApiImplicitParam(name = "atlas_process_calculate_params", value = "设置计算椭球坐标系"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/geodesic_area"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> geodesicAreaProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_calculate_new_name") String geodesicArea,
            @RequestParam(value = "atlas_process_calculate_is_new") String isNewField,
            @RequestParam(value = "atlas_process_calculate_params") String targetEllipsoidal,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        paramMaps.put(constants.calculateTarget(), constants.calculateTargetGeodesicArea());
        return spatialStatisticServer.calculateProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("投影面积计算")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_calculate_new_name", value = "设置计算后的新字段名称"),
            @ApiImplicitParam(name = "atlas_process_calculate_is_new", value = "设置计算后的字段是否为新增字段"),
            @ApiImplicitParam(name = "atlas_process_calculate_params", value = "设置计算投影面积"),
            @ApiImplicitParam(name = "atlas_process_calculate_zone", value = "设置3度或6度投影带"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/project_area"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> projectAreaProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_calculate_new_name") String geodesicArea,
            @RequestParam(value = "atlas_process_calculate_is_new") String isNewField,
            @RequestParam(value = "atlas_process_calculate_params", required = false) String targetEllipsoidal,
            @RequestParam(value = "atlas_process_calculate_zone", required = false, defaultValue = "3") Integer zone,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        paramMaps.put(constants.calculateTarget(), constants.calculateTargetProjectArea());
        return spatialStatisticServer.calculateProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("属性统计")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_filter_sql", value = "设置基础图层筛选信息", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_group_fields", value = "设置分组字段"),
            @ApiImplicitParam(name = "atlas_process_statistic_type", value = "设置统计类型", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_calculate_fields", value = "设置统计字段", required = true),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/groupby"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> groupByProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_filter_sql") String filterSql,
            @RequestParam(value = "atlas_process_statistic_group_fields") String groupFields,
            @RequestParam(value = "atlas_process_statistic_type") String statisticType,
            @RequestParam(value = "atlas_process_statistic_calculate_fields") String calculateFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.process.filter.sql",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        return spatialStatisticServer.groupByProcess(
                baseIdentity,
                filterSql,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("行转列")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_filter_sql", value = "属性筛选表达式"),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_property_field", value = "行转置字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_col_property_field", value = "分组字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_value_field", value = "行转置的值字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_map", value = "转置参数"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/bycol"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> byDictProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_filter_sql", required = false) String filterSql,
            @RequestParam(value = "atlas_process_statistic_bycol_row_property_field") String rowPropertyField,
            @RequestParam(value = "atlas_process_statistic_bycol_col_property_field") String colPropertyField,
            @RequestParam(value = "atlas_process_statistic_bycol_value_field") String valueField,
            @RequestParam(value = "atlas_process_statistic_bycol_row_map", required = false) String rowMap,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.process.filter.sql",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        return spatialStatisticServer.byDictProcess(
                baseIdentity,
                filterSql,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("行转列（空间分组）")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_filter_sql", value = "属性筛选表达式"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置空间分组图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_property_field", value = "行转置字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_value_field", value = "行转置的值字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_map", value = "转置参数"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/byshape"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> byShapeProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_filter_sql", required = false) String filterSql,
            @RequestParam(value = "atlas_data_other_identity") String staticIdentity,
            @RequestParam(value = "atlas_process_statistic_bycol_row_property_field") String rowPropertyField,
            @RequestParam(value = "atlas_process_statistic_bycol_value_field") String valueField,
            @RequestParam(value = "atlas_process_statistic_bycol_row_map", required = false) String rowMap,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.process.filter.sql",
                        "atlas.data.other.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        return spatialStatisticServer.byShapeProcess(
                baseIdentity,
                filterSql,
                staticIdentity,
                rowPropertyField,
                valueField,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("GeoSot网格统计")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_param", value = "GeoSot网格层级", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_field", value = "GeoSot编码字段", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_recompute_fields", value = "面积字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_property_field", value = "统计字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_map", value = "值域映射字典"),
            @ApiImplicitParam(name = "atlas_process_geosot_save_shape", value = "是否保留网格图形", defaultValue = "true"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/geosot"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> geosotProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_grid_split_code_param") String codeParam,
            @RequestParam(value = "atlas_process_grid_split_code_field") String codeField,
            @RequestParam(value = "atlas_process_grid_split_recompute_fields") String recomputFields,
            @RequestParam(value = "atlas_process_statistic_bycol_row_property_field") String staticField,
            @RequestParam(value = "atlas_process_statistic_bycol_row_map", required = false) String valueSpace,
            @RequestParam(value = "atlas_process_geosot_save_shape", defaultValue = "true", required = false) Boolean saveShape,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {

        // atlas_process_grid_split_mode 1
        // atlas_process_statistic_bycol_col_property_field atlas_process_grid_split_code_field
        // atlas_process_statistic_bycol_value_field atlas_process_grid_split_recompute_fields
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.process.geosot.save.shape",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        // 补充默认参数
        paramMaps.put(constants.gridSplitMode(), "1");
        paramMaps.put(constants.staticByColPropertyField(), codeField);
        paramMaps.put("atlas.process.statistic.bycol.value.field", recomputFields);
        paramMaps.put("atlas.process.statistic.bycol.add.statistic", "true");

        return spatialStatisticServer.gridStatistic(
                baseIdentity,
                saveShape,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("等分网格统计")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_param", value = "等分网格间距", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_code_field", value = "网格编码字段", required = true),
            @ApiImplicitParam(name = "atlas_process_grid_split_recompute_fields", value = "面积字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_property_field", value = "统计字段", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_bycol_row_map", value = "值域映射字典"),
            @ApiImplicitParam(name = "atlas_process_geosot_save_shape", value = "是否保留网格图形", defaultValue = "true"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/gwgrid"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> gwGridProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_grid_split_code_param") String codeParam,
            @RequestParam(value = "atlas_process_grid_split_code_field") String codeField,
            @RequestParam(value = "atlas_process_grid_split_recompute_fields") String recomputFields,
            @RequestParam(value = "atlas_process_statistic_bycol_row_property_field") String staticField,
            @RequestParam(value = "atlas_process_statistic_bycol_row_map", required = false) String valueSpace,
            @RequestParam(value = "atlas_process_geosot_save_shape", defaultValue = "true", required = false) Boolean saveShape,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {

        // atlas_process_grid_split_mode 1
        // atlas_process_statistic_bycol_col_property_field atlas_process_grid_split_code_field
        // atlas_process_statistic_bycol_value_field atlas_process_grid_split_recompute_fields
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.process.geosot.save.shape",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        // 补充默认参数
        paramMaps.put(constants.gridSplitMode(), "0");
        paramMaps.put(constants.staticByColPropertyField(), codeField);
        paramMaps.put("atlas.process.statistic.bycol.value.field", recomputFields);
        paramMaps.put("atlas.process.statistic.bycol.add.statistic", "true");

        return spatialStatisticServer.gridStatistic(
                baseIdentity,
                saveShape,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("SQL查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置图层1标识"),
            @ApiImplicitParam(name = "atlas_data_base_suffix", value = "设置SQL语句中图层1额外的后缀"),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置图层2标识"),
            @ApiImplicitParam(name = "atlas_data_other_suffix", value = "设置SQL语句中图层2额外的后缀"),
            @ApiImplicitParam(name = "atlas_process_run_sql_expression", value = "设置Sql表达式", required = true),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/sql"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> sqlProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_base_suffix", required = false) String baseSuffix,
            @RequestParam(value = "atlas_data_other_identity", required = false) String otherIdentity,
            @RequestParam(value = "atlas_data_other_suffix", required = false) String otherSuffix,
            @RequestParam(value = "atlas_process_run_sql_expression") String sqlExpression,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.base.suffix",
                        "atlas.data.other.identity",
                        "atlas.data.other.suffix",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        return spatialStatisticServer.sqlProcess(
                baseIdentity,
                baseSuffix,
                otherIdentity,
                otherSuffix,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("平差")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_balance_diff_oid_field", value = "平差唯一标识", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_balance_diff_standard_area", value = "控制面积", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_balance_diff_recompute_area", value = "重算面积", required = true),
            @ApiImplicitParam(name = "atlas_process_statistic_balance_diff_round_digits", value = "保留位数", required = true),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/balance_diff"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> balanceDiffProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_balance_diff_oid_field") String oidField,
            @RequestParam(value = "atlas_process_balance_diff_standard_area") String standardArea,
            @RequestParam(value = "atlas_process_balance_diff_recompute_area") String recomputeArea,
            @RequestParam(value = "atlas_process_balance_diff_round_digits") String roundDigits,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));

        return spatialStatisticServer.balanceDiffProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

}
