package com.geoway.atlas.web.api.v2.dao.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.web.api.v2.dao.MetadataDao;
import com.geoway.atlas.web.api.v2.domain.metadata.LayerMetadata;
import com.geoway.atlas.web.api.v2.domain.metadata.MemoryMetadata;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2022/11/1 19:14
 */
@Component
public class RichTextMetadataDao implements MetadataDao {

    @Autowired
    private ObjectMapper objectMapper;

    @SneakyThrows
    @Override
    public LayerMetadata get(Object identity) {
        Map<String, List<String>> storageInfo =
                (Map<String, List<String>>) objectMapper.readValue(identity.toString(), Map.class);
        return new LayerMetadata(null, storageInfo);
    }

    @Override
    public boolean setMemory(String identity, MemoryMetadata memoryMetadata) {
        return false;
    }
}
