package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * @author zhaotong 2024/11/25 20:51
 */
@Slf4j
public class TaskDetialMonitor extends QuartzJobBean {

    private static ConcurrentMap<String, Integer> preTaskInfo = new ConcurrentHashMap<>();

    private static JobManager jobManager = null;

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {

        try {
            if(jobManager == null){
                jobManager = AtlasGisToolkitBeanFactory.getBean(JobManager.class);
            }

            List<String> removeList = new ArrayList<>();

            // 间隔2分钟扫描1次,扫描3次task中均无内容则删除
            for(String taskId : jobManager.getFutureConcurrentMap().keySet()){
                // 如果存在空则计数加1,等于3直接删除任务
                if(jobManager.getFutureConcurrentMap().get(taskId) == null ||
                        jobManager.getFutureConcurrentMap().get(taskId).isEmpty()){
                    Integer acc = 0;
                    if(preTaskInfo.containsKey(taskId)){
                        acc = preTaskInfo.get(taskId);
                    }
                    // 当前task对应扫描到无内容的次数
                    acc += 1;
                    if(acc >= 3){
                        // 如果大于等于3则删除该taskid
                        jobManager.getFutureConcurrentMap().remove(taskId);
                        preTaskInfo.remove(taskId);
                        removeList.add(taskId);
                    }else {
                        // 如果小于3则放回等待下一次扫描
                        preTaskInfo.put(taskId, acc);
                    }
                }
                // 如果不存在空则说明有任务在进行则移除对应删除任务
                else {
                    if(preTaskInfo.containsKey(taskId)){
                        preTaskInfo.remove(taskId);
                    }
                }
            }

            if(!removeList.isEmpty()){
                log.info(String.format("移除任务 %s 成功", StringUtils.join(removeList, ",")));
            }
        } catch (Throwable e) {
            log.error("任务监控线程异常!", e);
        }
    }
}
