package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.web.api.v2.domain.metadata.LayerMetadata;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

/**
 * @author zhaotong 2024/7/15 15:19
 */
public class SecurityUtils {

    public static final String AES = "AES";
    public static final String BASE64 = "base64";

    public static final String AES_MODE = "AES/CBC/PKCS5Padding";

    public static final SecretKeySpec KEY_AES = new SecretKeySpec("geowayhtrksyaqjd".getBytes(StandardCharsets.UTF_8), AES);
    public static final IvParameterSpec IV_AES = new IvParameterSpec("atlasrqhansnbgjs".getBytes(StandardCharsets.UTF_8));

    /**
     * 解码字符串
     *
     * @param raw 原始字符串
     * @return 如果是加密字符串，则解码，否则返回原字符串
     */
    public static String dencrypt(String raw) {
        int maoHaoIndex = raw.indexOf(":");
        if (maoHaoIndex > 0) {
            String format = raw.substring(0, maoHaoIndex);
            if (StringUtils.endsWithIgnoreCase(format, BASE64)) {
                return SecurityUtils.dencrypt(StringUtils.substring(raw, maoHaoIndex + 1), 0);
            }
            if (StringUtils.startsWithIgnoreCase(format, LayerMetadata.SECRET)) {
                int secretType = Integer.parseInt(StringUtils.substring(format, LayerMetadata.SECRET.length()));
                return SecurityUtils.dencrypt(StringUtils.substring(raw, maoHaoIndex + 1), secretType);
            }
        }
        return raw;
    }

    public static String encrypt(String base, int type) {
        if (type == 0) {
            return new String(Base64.getEncoder().encode(base.getBytes(StandardCharsets.UTF_8)));
        } else if (type == 1) {
            try {
                return encryptAES(base);
            } catch (InvalidAlgorithmParameterException | NoSuchPaddingException | IllegalBlockSizeException |
                     NoSuchAlgorithmException | BadPaddingException | InvalidKeyException e) {
                throw new AtlasException(String.format("加密方式:%d, 无法加密字符串:%s", type, base));
            }
        } else {
            throw new AtlasException("不支持的加密方式:" + type);
        }
    }

    public static String dencrypt(String secret, int type) {
        if (type == 0) {
            return new String(Base64.getDecoder().decode(secret), StandardCharsets.UTF_8);
        } else if (type == 1) {
            try {
                return dencryptAES(secret);
            } catch (InvalidAlgorithmParameterException | NoSuchPaddingException | IllegalBlockSizeException |
                     NoSuchAlgorithmException | BadPaddingException | InvalidKeyException e) {
                throw new AtlasException(String.format("解密方式:%d, 不识别的加密字符串:%s", type, secret));
            }
        } else {
            throw new AtlasException("不支持的解密方式:" + type);
        }
    }

    /**
     * 加密接口
     * 采用AES加密
     *
     * @param base 明文字符串
     * @return 返回加密字符串
     * @throws NoSuchAlgorithmException
     */
    public static String encryptAES(String base) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(Cipher.ENCRYPT_MODE, KEY_AES, IV_AES);
        return Base64.getEncoder().encodeToString(cipher.doFinal(base.getBytes(StandardCharsets.UTF_8)));
    }

    /**
     * 解密接口
     * 采用AES解密
     *
     * @param secret 密文字符串
     * @return 返回明文字符串
     * @throws NoSuchAlgorithmException
     */
    public static String dencryptAES(String secret) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(Cipher.DECRYPT_MODE, KEY_AES, IV_AES);
        return new String(cipher.doFinal(Base64.getDecoder().decode(secret)), StandardCharsets.UTF_8);
    }

}
