/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.controller;

import com.geoway.atlas.web.api.v2.exception.ExceptionDeal;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Atlas\u6570\u636e\u76f8\u5173\u63a5\u53e3", tags={"\u6570\u636e\u63a5\u53e3"})
@RequestMapping(value={"/api/v2/data"})
@RestController
@CrossOrigin(origins={"*"})
public class DataController {
    @Autowired
    private DataServer dataServer;

    @ApiOperation(value="\u8f7d\u5165\u77e2\u91cf\u6570\u636e\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataStoreFormat", value="\u6570\u636e\u683c\u5f0f", required=true), @ApiImplicitParam(name="atlas_data_url", value="\u8f7d\u5165\u6570\u636e\u7684\u8def\u5f84", required=true), @ApiImplicitParam(name="atlas_data_load_name", value="\u6570\u636e\u540d\u79f0"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @GetMapping(value={"/vector/load/{dataStoreFormat}"}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> loadVector(@PathVariable String dataStoreFormat, @RequestParam(value="atlas_data_url") String dataUrl, @RequestParam(value="atlas_data_load_name") String dataName, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Collections.singletonList("atlas.data.load.name"));
        return this.dataServer.loadVector(dataName, dataStoreFormat, paramMaps, nTaskId, jobId);
    }

    @ApiOperation(value="\u8f93\u51fa\u77e2\u91cf\u6570\u636e\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataStoreFormat", value="\u6570\u636e\u683c\u5f0f", required=true), @ApiImplicitParam(name="atlas_data_url", value="\u8f93\u51fa\u6570\u636e\u7684\u8def\u5f84", required=true), @ApiImplicitParam(name="atlas_data_load_name", value="\u6570\u636e\u540d\u79f0"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @GetMapping(value={"/vector/save/{dataStoreFormat}"}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> saveVector(@PathVariable String dataStoreFormat, @RequestParam(value="atlas_data_url") String dataUrl, @RequestParam(value="atlas_data_load_name") String dataName, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Collections.singletonList("atlas.data.load.name"));
        return this.dataServer.saveVector(dataName, dataStoreFormat, paramMaps, nTaskId, jobId);
    }

    @ApiOperation(value="\u67e5\u770b\u6570\u636e")
    @GetMapping(value={"/_show"}, produces={"application/json"})
    @ExceptionDeal
    public Map<String, Object> showVector() {
        return this.dataServer.showVector();
    }

    @ApiOperation(value="\u6570\u636e\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas.data.desc.name", value="\u6570\u636e\u540d\u79f0"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @GetMapping(value={"/_desc"}, produces={"application/json"})
    @ExceptionDeal
    public Map<String, Object> descVector(@RequestParam(value="atlas.data.desc.name") String dataName, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        return this.dataServer.descVector(dataName, nTaskId, jobId);
    }

    @ApiOperation(value="\u6570\u636e\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas.data.desc.name", value="\u6570\u636e\u540d\u79f0"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @GetMapping(value={"/_exist"}, produces={"application/json"})
    @ExceptionDeal
    public Map<String, Object> existVector(@RequestParam(value="atlas.data.desc.name") String dataName, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        return this.dataServer.existVector(dataName, nTaskId, jobId);
    }
}

