/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.license.jna;

import com.geoway.atlas.web.api.v2.license.jna.OSInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Properties;

public class NativeLoader {
    private static final boolean isWindows = OSInfo.isWindows();

    public static String initializeLibrary(String libName) {
        String sqliteNativeLibraryName = System.mapLibraryName(libName);
        String sqliteNativeLibraryPath = "/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        if (NativeLoader.class.getResource(sqliteNativeLibraryPath + "/" + sqliteNativeLibraryName) == null) {
            return null;
        }
        String tempFolder = isWindows ? new File(System.getProperty("java.io.tmpdir")).getAbsolutePath() : "/tmp";
        System.out.println("tmpdir : " + tempFolder);
        try {
            return NativeLoader.extractLibraryFile(sqliteNativeLibraryPath, sqliteNativeLibraryName, tempFolder);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) throws IOException {
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String prefix = "license-" + NativeLoader.getVersion() + "-" + OSInfo.getArchName() + "-";
        String extractedLibFileName = libraryFileName;
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        if (extractedLibFile.exists()) {
            String md5sum2;
            String md5sum1 = NativeLoader.md5sum(NativeLoader.class.getResourceAsStream(nativeLibraryFilePath));
            if (md5sum1.equals(md5sum2 = NativeLoader.md5sum(new FileInputStream(extractedLibFile)))) {
                return extractedLibFile.getAbsolutePath();
            }
            boolean deletionSucceeded = extractedLibFile.delete();
            if (!deletionSucceeded) {
                throw new IOException("failed to remove existing standalone library file: " + extractedLibFile.getAbsolutePath());
            }
        }
        InputStream reader = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
        FileOutputStream writer = new FileOutputStream(extractedLibFile);
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
        writer.close();
        reader.close();
        if (!System.getProperty("os.name").contains("Windows")) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "755", extractedLibFile.getAbsolutePath()}).waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return extractedLibFile.getAbsolutePath();
    }

    static String md5sum(InputStream input) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(input);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = md5out.toString();
            return string;
        }
    }

    public static String getVersion() {
        URL versionFile = NativeLoader.class.getResource("/META-INF/maven/com.geoway.gspark/license/pom.properties");
        String version = "unknown";
        try {
            if (versionFile != null) {
                Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                version = version.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return version;
    }
}

