package com.geoway.atlas.web.api.v2.component.serverCenter.zk;

import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;

/**
 * @author zhaotong 2023/4/20 15:15
 */
public class NoSaslZookeeperFactory implements ZookeeperFactory {
    @Override
    public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        zkClientConfig.setProperty(ZKClientConfig.ENABLE_CLIENT_SASL_KEY, "false");
        return new ZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly, zkClientConfig);
    }
}
