package com.geoway.atlas.web.api.v2.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author zhaotong 2023/7/7 10:44
 */

@Component
@ConfigurationProperties(prefix = "hikari")
public class HikariPoolConfig {

    private long connectionTimeout;

    private long validationTimeout;

    private long idleTimeout;

    private long maxLifetime;

    private long maximumPoolSize;

    private long minimumIdle;

    private boolean readOnly;

    public HikariPoolConfig() {
    }

    public long getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getValidationTimeout() {
        return validationTimeout;
    }

    public void setValidationTimeout(long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public long getIdleTimeout() {
        return idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public long getMaxLifetime() {
        return maxLifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public long getMaximumPoolSize() {
        return maximumPoolSize;
    }

    public void setMaximumPoolSize(long maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getMinimumIdle() {
        return minimumIdle;
    }

    public void setMinimumIdle(long minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}
