package com.geoway.atlas.web.api.v2.service.pkg;

import java.util.Map;

/**
 * @author zhaotong 2023/8/15 18:56
 */
public interface GraphAnalysisServer {

    /**
     * 单源最短路径查询接口
     *
     * @param baseIdentity   图层标识（名称或url）
     * @param params         参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化
     * @param resultUrl      结果图层地址
     * @param taskId         任务id
     * @param jobId          工作项id
     * @return 返回执行结果
     */
    Map<String, Object> commonProcess(
            String baseIdentity, String processName, Map<String, String> params,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId, String response);
}
