package com.geoway.atlas.web.api.v2.component.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zhaotong 2022/10/31 10:22
 */
@JsonComponent
public class AtlasRpcDataDescSerializer extends StdSerializer<RpcDescDataRespond> {

    protected AtlasRpcDataDescSerializer() {
        super(RpcDescDataRespond.class);
    }

    @Override
    public void serialize(RpcDescDataRespond descDataRespond, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Map<String, Object> finalMap = new HashMap<>();

        Map<String, String> descMap = descDataRespond.getDataDescMap();

//        List<RpcFieldInfo> rpcFieldInfoList = descDataRespond.getFieldInfoList();
//
//        List<Map<String, String>> fieldInfoMapList = rpcFieldInfoList.stream().map(rpcFieldInfo -> {
//            Map<String, String> fieldInfoMap = new HashMap<>();
//            fieldInfoMap.put(FIELD_NAME, rpcFieldInfo.getFieldName());
//            fieldInfoMap.put(FIELD_TYPE, rpcFieldInfo.getFieldType());
//            return fieldInfoMap;
//        }).collect(Collectors.toList());
//
//        finalMap.put(FIELD_INFO, fieldInfoMapList);
//        finalMap.put(DATA_DESC, descMap);

        jsonGenerator.writeObject(descMap);
    }
}
