package com.geoway.atlas.web.api.v2.component.rpc;

import com.geoway.atlas.data.vector.spark.common.rpc.client.SparkRpcClientApi;
import com.geoway.atlas.web.api.v2.domain.rpc.ConnectInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Component;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;

/**
 * @author zhaotong 2022/9/14 15:17
 */

@Component
public class RpcClientProxy {

    @Autowired
    private ApplicationArguments arguments;

    private SparkRpcClientApi sparkRpcClientApi;

    @Autowired
    @Qualifier(value = "rpcClientPool")
    private ExecutorService rpcClientPool;

    public void init(ConnectInfo connectInfo) {
        if (StringUtils.isNotBlank(connectInfo.getIp())) {
            sparkRpcClientApi = new SparkRpcClientApi(connectInfo.getIp(), connectInfo.getPort(), rpcClientPool);
        } else {
            String defaultAddress;
            try {
                defaultAddress = InetAddress.getLocalHost().getHostAddress();
            } catch (UnknownHostException e) {
                defaultAddress = "127.0.0.1";
            }
            sparkRpcClientApi = new SparkRpcClientApi(defaultAddress, connectInfo.getPort(), rpcClientPool);
        }
    }

    public SparkRpcClientApi getSparkRpcClientApi() {
        return sparkRpcClientApi;
    }
}
