package com.geoway.atlas.web.api.v2.dao;

import com.geoway.atlas.web.api.v2.domain.metadata.LayerMetadata;
import com.geoway.atlas.web.api.v2.domain.metadata.MemoryMetadata;

/**
 * 元数据操作层
 *
 * @author zhaotong 2022/10/31 14:11
 */
public interface MetadataDao {

    /**
     * 通过标识符获取图层相关的信息
     *
     * @param identity 图层标识
     * @return 返回图层元数据信息
     */
    LayerMetadata get(Object identity);

    /**
     * 通过元数据内容判断数据是否在内存中
     *
     * @param identity       图层标识
     * @param memoryMetadata 内存元数据
     * @return 返回是否插入成功
     */
    boolean setMemory(String identity, MemoryMetadata memoryMetadata);

}
