package com.geoway.atlas.web.api.v2.pool.dialect;

import com.geoway.atlas.web.api.v2.pool.DBDialect;
import org.springframework.stereotype.Component;

/**
 * @author zhaotong 2023/7/7 14:31
 */

@Component("postgresql")
public class PgDialect implements DBDialect {
    @Override
    public String getJdbcUrl(String ipAndPort, String dbName) {
        return "jdbc:postgresql://" + ipAndPort + "/" + dbName;
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }
}
