package com.geoway.atlas.web.api.v2.service;

import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataName;

import java.util.Map;

/**
 * Atlas执行器
 *
 * @author zhaotong 2022/9/14 19:45
 */
public interface ProcessServer {

    /**
     * 执行无数据源方法
     *
     * @param processName   执行器名称
     * @param processParams 执行方法参数
     * @param resultName    执行结果名称
     * @param taskId        taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> nilProcess(
            String processName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);


    /**
     * 单输入源执行器
     *
     * @param atlasDataName   矢量数据名称
     * @param processName     执行器名称
     * @param processParams   执行方法参数
     * @param resultName      执行结果名称
     * @param taskId          taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> unitaryProcess(
            String atlasDataName,
            String processName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);

    /**
     * 双输入源执行器
     *
     * @param baseName       基础矢量图层名称
     * @param otherDataName  其他矢量图层名称
     * @param processName    执行器名称
     * @param processParams  执行方法参数
     * @param resultName     执行结果名称
     * @param taskId         taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> binaryProcess(
            String baseName,
            String otherDataName,
            String processName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);


    /**
     * 单输入源执行器
     *
     * @param atlasDataNames 矢量数据数组
     * @param processName    执行器名称
     * @param processParams  执行方法参数
     * @param resultName     执行结果名称
     * @param taskId         taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    Map<String, Object> listProcess(
            String atlasDataNames,
            String processName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);


    /**
     * 筛选执行器
     *
     * @param atlasDataName 矢量数据名称
     * @param processParams 执行方法参数
     * @param resultName    执行结果名称
     * @param taskId        taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    String filterProcess(
            String atlasDataName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);

    /**
     * 面积计算执行器
     *
     * @param atlasDataName 矢量数据名称
     * @param processParams 执行方法参数
     * @param resultName    执行结果名称
     * @param taskId        taskId作为自动清除后缀
     * @return 返回载入数据后的正常返回值
     */
    String calculatorProcess(
            String atlasDataName,
            Map<String, String> processParams,
            String resultName,
            String taskId,
            String jobId);
}
