package com.geoway.atlas.web.api.v2.service.pkg;

import java.util.Map;

/**
 * 数据管理服务接口
 *
 * @author zhaotong 2022/11/4 0:08
 */
public interface DataManagerServer {

    /**
     * 属性筛选
     *
     * @param baseIdentity   基础图层标识
     * @param filterParams   基础图层筛选条件
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化到磁盘
     * @param resultUrl      持久化磁盘的url
     * @param taskId         任务Id
     * @param jobId          jobId
     * @return 返回标识的结果
     */
    Map<String, Object> filterProcess(String baseIdentity,
                                      Map<String, String> filterParams,
                                      String resultIdentity,
                                      boolean persistDisk,
                                      String resultUrl,
                                      String taskId,
                                      String jobId);

    /**
     * 矢量数据转换接口
     *
     * @param baseIdentity   图层标识（名称或url）
     * @param ioParams       输入输出参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化
     * @param resultUrl      结果图层地址
     * @param taskId         任务id
     * @param jobId          工作项id
     * @return 返回执行结果
     */
    Map<String, Object> vectorIoProcess(
            String baseIdentity, Map<String, String> ioParams,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId);

    /**
     * 图数据转换接口
     *
     * @param baseIdentity   图层标识（名称或url）
     * @param ioParams       输入输出参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化
     * @param resultUrl      结果图层地址
     * @param taskId         任务id
     * @param jobId          工作项id
     * @return 返回执行结果
     */
    Map<String, Object> graphIoProcess(
            String baseIdentity, Map<String, String> ioParams,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId);


    /**
     * 实体关系构架
     *
     * @param baseIdentity   图层标识（名称或url）
     * @param ioParams       输入输出参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化
     * @param resultUrl      结果图层地址
     * @param taskId         任务id
     * @param jobId          工作项id
     * @return 返回执行结果
     */
    Map<String, Object> toGraphProcess(
            String baseIdentity, Map<String, String> ioParams,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId);

    /**
     * 字段计算
     *
     * @param baseIdentity    基础图层标识
     * @param calcFieldParams 字段计算参数
     * @param resultIdentity  结果图层标识
     * @param persistDisk     是否持久化到磁盘
     * @param resultUrl       持久化磁盘的url
     * @param taskId          任务Id
     * @param jobId           jobId
     * @return 返回标识的结果
     */
    Map<String, Object> calcFieldProcess(String baseIdentity,
                                         Map<String, String> calcFieldParams,
                                         String resultIdentity,
                                         boolean persistDisk,
                                         String resultUrl,
                                         String taskId,
                                         String jobId);


    /**
     * 图斑生成
     *
     * @param baseIdentity       基础图层标识
     * @param geoGeneratorParams 图斑生成参数
     * @param resultIdentity     结果图层标识
     * @param persistDisk        是否持久化到磁盘
     * @param resultUrl          持久化磁盘的url
     * @param taskId             任务Id
     * @param jobId              jobId
     * @return 返回标识的结果
     */
    Map<String, Object> geoGeneratorProcess(String baseIdentity,
                                            Map<String, String> geoGeneratorParams,
                                            String resultIdentity,
                                            boolean persistDisk,
                                            String resultUrl,
                                            String taskId,
                                            String jobId);

    /**
     * 判断图层关系
     *
     * @param baseIdentity    基础图层标识
     * @param calcFieldParams 基础图层筛选条件
     * @param resultIdentity  结果图层标识
     * @param persistDisk     是否持久化到磁盘
     * @param resultUrl       持久化磁盘的url
     * @param taskId          任务Id
     * @param jobId           jobId
     * @return 返回标识的结果
     */
    Map<String, Object> overlayRelate(String baseIdentity,
                                      Map<String, String> calcFieldParams,
                                      String resultIdentity,
                                      boolean persistDisk,
                                      String resultUrl,
                                      String taskId,
                                      String jobId);

    /**
     * 字段重命名
     *
     * @param baseIdentity   基础图层标识
     * @param filterParams   基础图层筛选条件
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化到磁盘
     * @param resultUrl      持久化磁盘的url
     * @param taskId         任务Id
     * @param jobId          jobId
     * @return 返回标识的结果
     */
    Map<String, Object> fieldRenameProcess(String baseIdentity,
                                           Map<String, String> filterParams,
                                           String resultIdentity,
                                           boolean persistDisk,
                                           String resultUrl,
                                           String taskId,
                                           String jobId);

    /**
     * 投影
     *
     * @param baseIdentity   基础图层标识
     * @param crsParams      坐标转换srid
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化到磁盘
     * @param resultUrl      持久化磁盘的url
     * @param taskId         任务Id
     * @param jobId          jobId
     * @return 返回标识的结果
     */
    Map<String, Object> projectProcess(String baseIdentity,
                                       Map<String, String> crsParams,
                                       String resultIdentity,
                                       boolean persistDisk,
                                       String resultUrl,
                                       String taskId,
                                       String jobId);

    /**
     * 合并图层
     *
     * @param baseIdentity   基础图层标识
     * @param mergeIdentity  联合图层标识
     * @param mergeParams    合并图层参数
     * @param resultIdentity 结果图层标识
     * @param persistDisk    是否持久化到磁盘
     * @param resultUrl      持久化磁盘的url
     * @param taskId         任务Id
     * @param jobId          jobId
     * @return 返回标识的结果
     */
    Map<String, Object> mergeProcess(
            String baseIdentity, String mergeIdentity, Map<String, String> mergeParams,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId);

    /**
     * 属性连接
     *
     * @param baseIdentity    基础图层标识
     * @param leftBaseField   属性连接基于的基础图层字段
     * @param otherIdentity   连接图层标识
     * @param rightBaseField  属性连接基于的连接图层字段
     * @param joinFields      属性连接信息
     * @param fieldJoinParams 字段连接参数
     * @param resultIdentity  结果图层标识
     * @param persistDisk     是否持久化到磁盘
     * @param resultUrl       结果url
     * @param taskId          task的id
     * @param jobId           job的id
     * @return 返回响应信息
     */
    Map<String, Object> fieldJoinProcess(
            String baseIdentity, String otherIdentity,
            Map<String, String> fieldJoinParams,
            String resultIdentity, boolean persistDisk, String resultUrl,
            String taskId, String jobId);
}
