package com.geoway.atlas.function.parser.common;

import com.geoway.atlas.function.parser.FunctionDSLBaseLexer;
import com.geoway.atlas.function.parser.FunctionDSLBaseParser;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhaotong 2024/12/20 11:08
 */
public class FunctionDSLParser {

    static class UpperCaseCharStream implements CharStream {

        final CodePointCharStream wrapped;

        UpperCaseCharStream(CodePointCharStream wrapped){
            this.wrapped = wrapped;
        }

        @Override
        public void consume() { wrapped.consume(); }
        @Override
        public String getSourceName() { return wrapped.getSourceName();}
        @Override
        public int index() { return wrapped.index(); }
        @Override
        public int mark() { return wrapped.mark(); }
        @Override
        public void release(int marker) { wrapped.release(marker);}
        @Override
        public void seek(int index) { wrapped.seek(index); }
        @Override
        public int size() { return wrapped.size(); }
        @Override
        public String getText(Interval interval) {
            if (size() > 0 && (interval.b - interval.a >= 0)) {
                return wrapped.getText(interval);
            } else {
                return "";
            }
        }

        @Override
        public int LA(int i) {
            int la = wrapped.LA(i);
            if (la == 0 || la == IntStream.EOF) return la;
            else return Character.toUpperCase(la);
        }
    }

    public static final FunctionDSLAstBuilder builder = new FunctionDSLAstBuilder();

    public static FunctionPlan parser(String command){
        FunctionDSLBaseLexer lexer = new FunctionDSLBaseLexer(new UpperCaseCharStream(CharStreams.fromString(command)));
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        FunctionDSLBaseParser parser = new FunctionDSLBaseParser(tokenStream);
        // SLL 比 LL效率快
        try{
            parser.getInterpreter().setPredictionMode(PredictionMode.SLL);
            return (FunctionPlan) builder.visit(parser.singleStatement());
        }catch (ParseCancellationException e){
            parser.reset();
            parser.getInterpreter().setPredictionMode(PredictionMode.LL);
            return (FunctionPlan) builder.visit(parser.singleStatement());
        }
    }
}
