package com.geoway.atlas.web.api.v2.controller;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.config.ConfigLoader;
import com.geoway.atlas.common.config.ConfigLoader$;
import com.geoway.atlas.web.api.v2.exception.ExceptionDeal;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.AtlasServer;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * Atlas异步调用相关接口
 *
 * @author zhaotong 2022/9/7 9:39
 */
@Api(value = "Atlas异步任务查询相关接口", tags = "异步任务查询")
@RestController
@CrossOrigin(
        origins = {"*"}
)
public class AtlasController {

    @Autowired
    private AtlasServer atlasServer;

    @ExceptionDeal(isLog = false)
    @ApiOperation("异步任务结果查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "jobid", value = "工作项id", required = true)
    })
    @GetMapping(value = {"/atlas/jobresult"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> jobResult(@RequestParam(value = "jobid") String jobId) {
        return atlasServer.jobResult(jobId);
    }

    @ExceptionDeal(isLog = false)
    @ApiOperation("异步任务停止")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "jobid", value = "工作项id", required = true),
            @ApiImplicitParam(name = "taskid", value = "任务id", required = true)
    })
    @GetMapping(value = {"/atlas/canceljob"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> canceljob(
            @RequestParam(value = "taskid") String rawTaskId, @RequestParam(value = "jobid") String jobId) {
        return atlasServer.canceljob(rawTaskId, jobId);
    }

    @ExceptionDeal(isLog = false)
    @ApiOperation("配置查看")
    @GetMapping(value = {"/config"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> showConfig() {
        Map<String, Object> resultConfig = new HashMap<>();
        scala.collection.immutable.Map configMap = ConfigLoader$.MODULE$.Config();
        scala.collection.Iterator keyIterator = configMap.keysIterator();
        while (keyIterator.hasNext()) {
            String key = (String) keyIterator.next();
            String value = (String) ((scala.Tuple2) configMap.apply(key))._1();
            resultConfig.put(key, value);
        }
        return resultConfig;
    }

    @ApiOperation("模拟driver满载情况")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "cpu", defaultValue = "1", value = "driver的cpu线程数量")
    })
    @GetMapping(value = {"/debug/driver/business"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> debugDriverBusiness(
            @RequestParam(value = "cpu", required = false, defaultValue = "1") Integer cpu) {
        Runnable runnable = () -> {
            while (true) {
                double v = Math.random() * Math.random();
            }
        };
        for (int i = 0; i < cpu; i++) {
            Thread thread = new Thread(runnable);
            thread.start();
        }
        return ResponseBuilder.buildSuccess("模拟Driver满载任务已启动!");
    }

    @AsyncDeal
    @ApiOperation("异步任务Demo")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "duration", value = "持续时间")
    })
    @RequestMapping(value = {"/atlas/jobdemo"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> jobDemo(
            @RequestParam(value = "duration") long duration, Map<String, String> paramMaps) {
        return atlasServer.jobDemo(duration);
    }
}
