package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.function.parser.common.QualifiedName;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 合并值
 * @author zhaotong 2024/12/23 9:26
 */
public class ConcatValueFunctionPlan extends AssignFunctionPlan {

    /**
     * 0 - 默认按照名称进行排序
     * 1- 默认按照面积大小进行排序
     *
     */
    private int order = 0;

    /**
     * 当设置为负数时则保留全部精度
     */
    private int precision = 2;

    /**
     * 用户自定义的表达式
     */
//    private List<String> userDefineExpressions = new ArrayList<>();

    @Override
    public String functionName() {
        return "concat_value";
    }

    @Override
    public void setArgs(Object[] args) {
        if (args != null && args.length != 0) {
            if(args.length == 1){
                try {
                    order = (int) args[0];
                }catch (ClassCastException cce){
                    throw new AtlasException("请检查输入的排序类型，仅支持数字类型！");
                }
            }else {
                int computeFieldIndex = 0;
    //            if(args[computeFieldIndex] instanceof Integer){
                try {
                    order = (int) args[computeFieldIndex];
                    computeFieldIndex ++;
                }catch (ClassCastException cce){
                    throw new AtlasException("请检查输入的排序参数，仅支持字段类型！");
                }

                if(args[computeFieldIndex] instanceof Integer){
                    precision = (int) args[computeFieldIndex];
                    computeFieldIndex ++;
                }
    //            }

                if(!(args[computeFieldIndex] instanceof QualifiedName)){
                    throw new AtlasException("请检查输入的第" + (computeFieldIndex + 1) + "个字段参数，未知的参数类型:" + args[computeFieldIndex].getClass().getSimpleName());
                }

                try {
                    computeFields.add((QualifiedName) args[computeFieldIndex]);
                }catch (ClassCastException cce){
                    throw new AtlasException("请检查输入的字段参数，仅支持字段类型！");
                }

    //            if(args.length > computeFieldIndex + 1){
    //                for(int i = computeFieldIndex + 1; i < args.length; i++){
    //                    try{
    //                        userDefineExpressions.add((String) args[i]);
    //                    }catch (ClassCastException cce){
    //                        throw new AtlasException("请检查第" + (i - computeFieldIndex) + "个输入自定义表达式，仅支持字符串类型");
    //                    }
    //
    //                }
    //            }

    //            if(!userDefineExpressions.isEmpty()){
    //                if(inputOrder){
    //                    throw new AtlasException("自定义表达式时，不支持指定排序或精度！");
    //                }
    //            }

            }

            if(order !=0 && order != 1){
                throw new AtlasException("排序类型错误，仅支持0-按照名称排序 1-按照面积排序！");
            }
        } else {
            // 按照默认排序
        }


    }

    @Override
    public boolean needRepair() {
        return isNeedRecomputeArea();
    }

    /**
     * 或者使用concat_ws("、", transform(sort_array(collect_list(struct(id, area))), x -> concat_ws(':', x.id, x.area)))
     * @param statisticSql 统计sql
     * @param oidField oid字段的名称
     * @param assignFieldMaps 赋值字段映射，采用linkedhashmap，保证了keyset的顺序
     * @return
     */
    @Override
    public String getAssignFuncSql(String statisticSql, String oidField, Map<String, String> assignFieldMaps) {
        if(isNeedRecomputeArea() && assignFieldMaps.size() > 1){
            throw new AtlasException("需要展示面积信息时，仅支持1个赋值字段！");
        }
        String statisticViewAlias = "a_" + FIXED_ASSIGN_LAYER_SUFFIX;
        String areaName;
        if(isNeedRecomputeArea()){
            areaName = getFieldNameInLayer(computeFields.get(0));
        }else {
            areaName = intersectShapeAreaName;
        }

        String assignSql = assignFieldMaps.keySet().stream()
                .map(assignField -> statisticViewAlias + ".`" + addSuffixName(assignField) + "`")
                .collect(Collectors.joining(", "));
        String objField = "obj";
        String objSql = String.format("struct(%s.%s, %s, %s.%s) %s",
                statisticViewAlias, oidField, assignSql,statisticViewAlias, areaName, objField);

        String subSql = String.format("select %s.%s, %s from (%s) %s",
                statisticViewAlias, oidField, objSql, statisticSql, statisticViewAlias);

        String subSqlViewAlias = "aa_" + FIXED_ASSIGN_LAYER_SUFFIX;
        String resultAssignFieldSql = StringUtils.join(getExpression(assignFieldMaps, subSqlViewAlias, areaName, objField), ", ");
        return String.format("select %s.%s, %s from (%s) %s group by %s.%s",
                subSqlViewAlias, oidField, resultAssignFieldSql, subSql, subSqlViewAlias, subSqlViewAlias, oidField);
    }

    @Override
    protected String getAssignSelectSql(String statisticViewAlias, Map<String, String> assignFieldMaps) {
        throw new AtlasException("未实现当前方法！");
    }

    @Override
    protected String getDefaultValExpr(String viewName, String fieldName) {
        String defaultValue = defaultValueMap.get(fieldName);
        if(!StringUtils.startsWith(defaultValue, "'")){
            defaultValue = "'" + defaultValue + "'";
        }
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }

    @Override
    protected String getUndefineValExpr(String viewName, String fieldName) {
        // 默认值为空字符串
        String defaultValue = "''";
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }

    /**
     * 获取表达式
     * @param assignFieldMaps 赋值字段映射列表
     * @param subSqlViewAlias 子查询表别名
     * @param areaName 面积字段名称
     * @return 返回表达式列表
     */
    private List<String> getExpression(Map<String, String> assignFieldMaps, String subSqlViewAlias, String areaName, String objField){
        List<String> result = new ArrayList<>();
        int i = 0;
        // 遍历assignFieldMaps字典
        for(String key: assignFieldMaps.keySet()){
            String express;
            String keyWithSuffix = addSuffixName(key);
            String sortBy;
            if(order == 0) {
                sortBy = String.format("(left, right) -> case when left.`%s` < right.`%s` then -1 when left.`%s` > right.`%s` then 1 else 0 end"
                        , keyWithSuffix, keyWithSuffix, keyWithSuffix, keyWithSuffix);
            }else {
                sortBy = String.format("(left, right) -> case when left.`%s` < right.`%s` then 1 when left.`%s` > right.`%s` then -1 else 0 end"
                        , areaName, areaName, areaName, areaName);
            }


            if (isNeedRecomputeArea()) {
                String areaAggSql;
                if (precision < 0) {
                    areaAggSql = "x.`" + areaName + "`";
                } else {
                    areaAggSql = String.format("round(x.`%s`, %d)", areaName, precision);
                }

//                    express = String.format("concat_ws(',', array_except(collect_list(case when %s.%s.`%s` is null then null else concat_ws(':', %s.%s.`%s`, %s) end), array(null)))",
                express = String.format("concat_ws(',', transform(array_sort(array_except(" +
                                "collect_list(case when %s.%s.`%s` is null then null else %s.%s end), " +
                                "array(null)), %s), " +
                                "x -> concat_ws(':', x.`%s`, %s)))",
                        subSqlViewAlias, objField, keyWithSuffix, subSqlViewAlias, objField, sortBy, keyWithSuffix, areaAggSql);
            } else {
                express = String.format("concat_ws(',', transform(array_distinct(array_sort(array_except(" +
                                "collect_list(case when %s.%s.`%s` is null then null else %s.%s end), " +
                                "array(null)), %s)), " +
                                "x -> x.`%s`))",
                        subSqlViewAlias, objField, keyWithSuffix, subSqlViewAlias, objField, sortBy, keyWithSuffix);
            }
            result.add(express + " as " + assignFieldMaps.get(key));
        }

        return result;
    }
}
