/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.web.api.v2.exception.AtlasException;
import com.geoway.atlas.web.api.v2.service.pkg.impl.assigin.AssignFunctionPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SumRateFunctionPlan
extends AssignFunctionPlan {
    private int precision = -1;

    @Override
    public String functionName() {
        return "sum_rate";
    }

    @Override
    public boolean needRepair() {
        return true;
    }

    @Override
    public List<String> unusedFields(List<String> fields, Map<String, String> assignFieldMap) {
        ArrayList<String> removeFields = new ArrayList<String>(fields);
        removeFields.remove(this.baseShapeAreaName);
        return removeFields;
    }

    @Override
    public String getStatisticSql(String middleLayer, Collection<String> assignFields, String oidField) {
        return String.format("select *, %s / %s as %s  from %s", this.intersectShapeAreaName, this.baseShapeAreaName, this.RATE_NAME, middleLayer);
    }

    @Override
    public void setArgs(Object[] args) {
        if (args != null && args.length == 1 && args[0] != null) {
            try {
                this.precision = (Integer)args[0];
            }
            catch (ClassCastException cce) {
                throw new AtlasException("\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u7cbe\u5ea6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301\u6570\u5b57\u7c7b\u578b\uff01");
            }
        }
    }

    @Override
    protected String getAssignSelectSql(String statisticViewAlias, Map<String, String> assignFieldMaps) {
        if (assignFieldMaps.size() != 1) {
            throw new AtlasException("\u8bf7\u68c0\u67e5\u8f93\u5165\u8d4b\u503c\u5b57\u6bb5\uff0c\u4ec5\u652f\u63011\u4e2a\u8d4b\u503c\u5b57\u6bb5\u4f5c\u4e3a\u7ed3\u679c\u56fe\u5c42\u6bd4\u4f8b\u5b57\u6bb5");
        }
        String nRateName = assignFieldMaps.values().stream().findFirst().get();
        if (this.precision < 0) {
            return String.format("case when sum(%s.%s) > 1.0 then 1.0 else sum(%s.%s) end as %s", statisticViewAlias, this.RATE_NAME, statisticViewAlias, this.RATE_NAME, nRateName);
        }
        return String.format("case when round(sum(%s.%s), %d) > 1.0 then 1.0 else round(sum(%s.%s), %d) end as %s", statisticViewAlias, this.RATE_NAME, this.precision, statisticViewAlias, this.RATE_NAME, this.precision, nRateName);
    }

    @Override
    protected String getDefaultValExpr(String viewName, String fieldName) {
        String defaultValue = (String)this.defaultValueMap.get(fieldName);
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }

    @Override
    protected String getUndefineValExpr(String viewName, String fieldName) {
        String defaultValue = "0.0";
        return String.format("case when %s.%s is null then %s else %s.%s end as %s", viewName, fieldName, defaultValue, viewName, fieldName, fieldName);
    }
}

