/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDUtils {
    private static byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 45};

    public static String getUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long lsb = random.nextLong();
        long msb = random.nextLong();
        byte[] buf = new byte[32];
        int radix = 16;
        UUIDUtils.formatUnsignedLong(lsb, radix, buf, 20, 12);
        UUIDUtils.formatUnsignedLong(lsb >>> 48, radix, buf, 16, 4);
        UUIDUtils.formatUnsignedLong(msb, radix, buf, 12, 4);
        UUIDUtils.formatUnsignedLong(msb >>> 16, radix, buf, 8, 4);
        UUIDUtils.formatUnsignedLong(msb >>> 32, radix, buf, 0, 8);
        return new String(buf, StandardCharsets.UTF_8);
    }

    private static void formatUnsignedLong(Long value, int radix, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int mask = radix - 1;
        Long tempValue = value;
        do {
            buf[--charPos] = DIGITS[tempValue.intValue() & mask];
            tempValue = tempValue >>> 4;
        } while (charPos > offset);
    }
}

